/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.AzimuthalGradientCoefficients;
import org.orekit.models.earth.troposphere.AzimuthalGradientProvider;
import org.orekit.models.earth.troposphere.FieldAzimuthalGradientCoefficients;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphereMappingFunction;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.ViennaAProvider;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public abstract class AbstractVienna
implements TroposphericModel,
TroposphereMappingFunction {
    private static final double C = 0.0032;
    private final ViennaAProvider aProvider;
    private final AzimuthalGradientProvider gProvider;
    private final TroposphericModel zenithDelayProvider;
    private final TimeScale utc;

    protected AbstractVienna(ViennaAProvider aProvider, AzimuthalGradientProvider gProvider, TroposphericModel zenithDelayProvider, TimeScale utc) {
        this.aProvider = aProvider;
        this.gProvider = gProvider;
        this.zenithDelayProvider = zenithDelayProvider;
        this.utc = utc;
    }

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double gw;
        double gh;
        TroposphericDelay delays = this.zenithDelayProvider.pathDelay(trackingCoordinates, point, weather, parameters, date);
        double[] mappingFunction = this.mappingFactors(trackingCoordinates, point, weather, date);
        AzimuthalGradientCoefficients agc = this.gProvider.getGradientCoefficients(point, date);
        if (agc != null) {
            double sinE = FastMath.sin((double)trackingCoordinates.getElevation());
            double tanE = FastMath.tan((double)trackingCoordinates.getElevation());
            double mfh = 1.0 / (sinE * tanE + 0.0032);
            SinCos sc = FastMath.sinCos((double)trackingCoordinates.getAzimuth());
            gh = mfh * (agc.getGnh() * sc.cos() + agc.getGeh() * sc.sin());
            gw = mfh * (agc.getGnw() * sc.cos() + agc.getGew() * sc.sin());
        } else {
            gh = 0.0;
            gw = 0.0;
        }
        return new TroposphericDelay(delays.getZh(), delays.getZw(), delays.getZh() * mappingFunction[0] + gh, delays.getZw() * mappingFunction[1] + gw);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement gw;
        CalculusFieldElement gh;
        FieldTroposphericDelay delays = this.zenithDelayProvider.pathDelay(trackingCoordinates, point, weather, (CalculusFieldElement[])parameters, date);
        CalculusFieldElement[] mappingFunction = this.mappingFactors(trackingCoordinates, point, weather, date);
        FieldAzimuthalGradientCoefficients<T> agc = this.gProvider.getGradientCoefficients(point, date);
        if (agc != null) {
            CalculusFieldElement sinE = FastMath.sin(trackingCoordinates.getElevation());
            CalculusFieldElement tanE = FastMath.tan(trackingCoordinates.getElevation());
            CalculusFieldElement mfh = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.multiply((FieldElement)tanE)).add(0.0032)).reciprocal();
            FieldSinCos sc = FastMath.sinCos(trackingCoordinates.getAzimuth());
            gh = (CalculusFieldElement)mfh.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)agc.getGnh().multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add((FieldElement)((CalculusFieldElement)agc.getGeh().multiply((FieldElement)((CalculusFieldElement)sc.sin()))))));
            gw = (CalculusFieldElement)mfh.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)agc.getGnw().multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add((FieldElement)((CalculusFieldElement)agc.getGew().multiply((FieldElement)((CalculusFieldElement)sc.sin()))))));
        } else {
            gh = (CalculusFieldElement)date.getField().getZero();
            gw = (CalculusFieldElement)date.getField().getZero();
        }
        return new FieldTroposphericDelay<CalculusFieldElement>((CalculusFieldElement)delays.getZh(), (CalculusFieldElement)delays.getZw(), (CalculusFieldElement)((CalculusFieldElement)delays.getZh().multiply((FieldElement)mappingFunction[0])).add((FieldElement)gh), (CalculusFieldElement)((CalculusFieldElement)delays.getZw().multiply((FieldElement)mappingFunction[1])).add((FieldElement)gw));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    protected ViennaAProvider getAProvider() {
        return this.aProvider;
    }

    protected int getDayOfYear(AbsoluteDate date) {
        return date.getComponents(this.utc).getDate().getDayOfYear();
    }
}

