/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.TroposphereMappingFunction;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.TrackingCoordinates;

public class AbstractChaoMappingFunction
implements TroposphereMappingFunction {
    private final double ad;
    private final double bd;
    private final double aw;
    private final double bw;

    protected AbstractChaoMappingFunction(double ad, double bd, double aw, double bw) {
        this.ad = ad;
        this.bd = bd;
        this.aw = aw;
        this.bw = bw;
    }

    @Override
    public double[] mappingFactors(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, AbsoluteDate date) {
        double sinE = FastMath.sin((double)trackingCoordinates.getElevation());
        double tanE = FastMath.tan((double)trackingCoordinates.getElevation());
        return new double[]{1.0 / (sinE + this.ad / (tanE + this.bd)), 1.0 / (sinE + this.aw / (tanE + this.bw))};
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, FieldAbsoluteDate<T> date) {
        CalculusFieldElement sinE = FastMath.sin(trackingCoordinates.getElevation());
        CalculusFieldElement tanE = FastMath.tan(trackingCoordinates.getElevation());
        CalculusFieldElement[] mapping = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
        mapping[0] = (CalculusFieldElement)((CalculusFieldElement)sinE.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tanE.add(this.bd)).reciprocal()).multiply(this.ad)))).reciprocal();
        mapping[1] = (CalculusFieldElement)((CalculusFieldElement)sinE.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tanE.add(this.bw)).reciprocal()).multiply(this.aw)))).reciprocal();
        return mapping;
    }
}

