/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.tessellation;

import java.util.List;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.Vertex;

class InsidePointFinder
implements BSPTreeVisitor<Sphere2D> {
    private final SphericalPolygonsSet zone;
    private S2Point insidePointSecondChoice;
    private S2Point insidePointFirstChoice;

    InsidePointFinder(SphericalPolygonsSet zone) {
        this.zone = zone;
        this.insidePointFirstChoice = null;
        this.insidePointSecondChoice = null;
    }

    public BSPTreeVisitor.Order visitOrder(BSPTree<Sphere2D> node) {
        return BSPTreeVisitor.Order.MINUS_PLUS_SUB;
    }

    public void visitInternalNode(BSPTree<Sphere2D> node) {
    }

    public void visitLeafNode(BSPTree<Sphere2D> node) {
        if (this.insidePointFirstChoice != null) {
            return;
        }
        if (((Boolean)node.getAttribute()).booleanValue()) {
            int n;
            SphericalPolygonsSet convex = new SphericalPolygonsSet(node.pruneAroundConvexCell((Object)Boolean.TRUE, (Object)Boolean.FALSE, null), this.zone.getTolerance());
            List boundary = convex.getBoundaryLoops();
            Vertex start = (Vertex)boundary.get(0);
            Vector3D centroid = Vector3D.ZERO;
            Edge e = start.getOutgoing();
            for (n = 0; n == 0 || e.getStart() != start; ++n) {
                Vector3D startPoint = e.getStart().getLocation().getVector();
                Vector3D endPoint = e.getEnd().getLocation().getVector();
                centroid = centroid.add((Vector)startPoint).add((Vector)endPoint);
                e = e.getEnd().getOutgoing();
            }
            S2Point candidate = new S2Point((Vector3D)(centroid = centroid.scalarMultiply(1.0 / (double)(2 * n))).normalize());
            if (this.zone.checkPoint((Point)candidate) == Region.Location.INSIDE) {
                this.insidePointFirstChoice = candidate;
            } else {
                this.insidePointSecondChoice = candidate;
            }
        }
    }

    public S2Point getInsidePoint() {
        return this.insidePointFirstChoice != null ? this.insidePointFirstChoice : this.insidePointSecondChoice;
    }
}

