/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;

public class KlobucharIonoModel
implements IonosphericModel {
    private final double[] alpha;
    private final double[] beta;
    private final TimeScale gps;

    @DefaultDataContext
    public KlobucharIonoModel(double[] alpha, double[] beta) {
        this(alpha, beta, DataContext.getDefault().getTimeScales().getGPS());
    }

    public KlobucharIonoModel(double[] alpha, double[] beta, TimeScale gps) {
        this.alpha = (double[])alpha.clone();
        this.beta = (double[])beta.clone();
        this.gps = gps;
    }

    public double pathDelay(AbsoluteDate date, GeodeticPoint geo, double elevation, double azimuth, double frequency, double[] parameters) {
        SinCos sc = FastMath.sinCos((double)azimuth);
        double rad2semi = 0.3183098861837907;
        double semi2rad = Math.PI;
        double psi = 0.0137 / (elevation / Math.PI + 0.11) - 0.022;
        double latIono = FastMath.min((double)FastMath.max((double)(geo.getLatitude() * 0.3183098861837907 + psi * sc.cos()), (double)-0.416), (double)0.416);
        double lonIono = geo.getLongitude() * 0.3183098861837907 + psi * sc.sin() / FastMath.cos((double)(latIono * Math.PI));
        double latGeom = latIono + 0.064 * FastMath.cos((double)((lonIono - 1.617) * Math.PI));
        DateTimeComponents dtc = date.getComponents(this.gps);
        int dofweek = dtc.getDate().getDayOfWeek();
        double secday = dtc.getTime().getSecondsInLocalDay();
        double tow = (double)dofweek * 86400.0 + secday;
        double t = 43200.0 * lonIono + tow;
        double tsec = t - FastMath.floor((double)(t / 86400.0)) * 86400.0;
        double slantFactor = 1.0 + 16.0 * FastMath.pow((double)(0.53 - elevation / Math.PI), (int)3);
        double period = FastMath.max((double)72000.0, (double)(this.beta[0] + (this.beta[1] + (this.beta[2] + this.beta[3] * latGeom) * latGeom) * latGeom));
        double x = Math.PI * 2 * (tsec - 50400.0) / period;
        double amplitude = FastMath.max((double)0.0, (double)(this.alpha[0] + (this.alpha[1] + (this.alpha[2] + this.alpha[3] * latGeom) * latGeom) * latGeom));
        double ionoTimeDelayL1 = slantFactor * 5.0E-9;
        if (FastMath.abs((double)x) < 1.57) {
            ionoTimeDelayL1 += slantFactor * (amplitude * (1.0 - FastMath.pow((double)x, (int)2) / 2.0 + FastMath.pow((double)x, (int)4) / 24.0));
        }
        double ratio = FastMath.pow((double)(1.57542E9 / frequency), (int)2);
        return ratio * 2.99792458E8 * ionoTimeDelayL1;
    }

    @Override
    public double pathDelay(SpacecraftState state, TopocentricFrame baseFrame, double frequency, double[] parameters) {
        Vector3D position = state.getPosition(baseFrame);
        double elevation = position.getDelta();
        if (elevation > 0.0) {
            AbsoluteDate date = state.getDate();
            GeodeticPoint geo = baseFrame.getPoint();
            double azimuth = FastMath.atan2((double)position.getX(), (double)position.getY());
            if (azimuth < 0.0) {
                azimuth += Math.PI * 2;
            }
            return this.pathDelay(date, geo, elevation, azimuth, frequency, parameters);
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T pathDelay(FieldAbsoluteDate<T> date, FieldGeodeticPoint<T> geo, T elevation, T azimuth, double frequency, T[] parameters) {
        FieldSinCos sc = FastMath.sinCos(azimuth);
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement pi = (CalculusFieldElement)one.getPi();
        CalculusFieldElement rad2semi = (CalculusFieldElement)pi.reciprocal();
        CalculusFieldElement psi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elevation.divide((FieldElement)pi)).add(0.11)).divide(0.0137)).reciprocal()).subtract(0.022);
        CalculusFieldElement latIono = FastMath.min((CalculusFieldElement)FastMath.max((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)geo.getLatitude().multiply((FieldElement)rad2semi)).add((FieldElement)((CalculusFieldElement)psi.multiply((FieldElement)((CalculusFieldElement)sc.cos()))))), (CalculusFieldElement)((CalculusFieldElement)zero.subtract(0.416))), (CalculusFieldElement)((CalculusFieldElement)zero.newInstance(0.416)));
        CalculusFieldElement lonIono = (CalculusFieldElement)((CalculusFieldElement)geo.getLongitude().multiply((FieldElement)rad2semi)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)psi.multiply((FieldElement)((CalculusFieldElement)sc.sin()))).divide((FieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)latIono.multiply((FieldElement)pi))))));
        CalculusFieldElement latGeom = (CalculusFieldElement)latIono.add((FieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)lonIono.subtract(1.617)).multiply((FieldElement)pi))).multiply(0.064)));
        DateTimeComponents dtc = date.getComponents(this.gps);
        int dofweek = dtc.getDate().getDayOfWeek();
        double secday = dtc.getTime().getSecondsInLocalDay();
        double tow = (double)dofweek * 86400.0 + secday;
        CalculusFieldElement t = (CalculusFieldElement)((CalculusFieldElement)lonIono.multiply(43200.0)).add(tow);
        CalculusFieldElement tsec = (CalculusFieldElement)t.subtract((FieldElement)((CalculusFieldElement)FastMath.floor((CalculusFieldElement)((CalculusFieldElement)t.divide(86400.0))).multiply(86400.0)));
        CalculusFieldElement slantFactor = (CalculusFieldElement)((CalculusFieldElement)FastMath.pow((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elevation.divide((FieldElement)pi)).negate()).add(0.53)), (int)3).multiply(16.0)).add((FieldElement)one);
        CalculusFieldElement period = FastMath.max((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(72000.0)), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)latGeom.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)latGeom.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)latGeom.multiply(this.beta[3])).add(this.beta[2])))).add(this.beta[1])))).add(this.beta[0])));
        CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)tsec.subtract(50400.0)).multiply((FieldElement)((CalculusFieldElement)pi.multiply(2.0)))).divide((FieldElement)period);
        CalculusFieldElement amplitude = FastMath.max((CalculusFieldElement)zero, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)latGeom.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)latGeom.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)latGeom.multiply(this.alpha[3])).add(this.alpha[2])))).add(this.alpha[1])))).add(this.alpha[0])));
        CalculusFieldElement ionoTimeDelayL1 = (CalculusFieldElement)slantFactor.multiply(5.0E-9);
        if (FastMath.abs((double)x.getReal()) < 1.57) {
            ionoTimeDelayL1 = (CalculusFieldElement)ionoTimeDelayL1.add((FieldElement)((CalculusFieldElement)slantFactor.multiply((FieldElement)((CalculusFieldElement)amplitude.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)FastMath.pow((CalculusFieldElement)x, (int)2).multiply(0.5)))).add((FieldElement)((CalculusFieldElement)FastMath.pow((CalculusFieldElement)x, (int)4).divide(24.0)))))))));
        }
        double ratio = FastMath.pow((double)(1.57542E9 / frequency), (int)2);
        return (T)((CalculusFieldElement)((CalculusFieldElement)ionoTimeDelayL1.multiply(2.99792458E8)).multiply(ratio));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(FieldSpacecraftState<T> state, TopocentricFrame baseFrame, double frequency, T[] parameters) {
        FieldVector3D<T> position = state.getPosition(baseFrame);
        CalculusFieldElement elevation = position.getDelta();
        if (elevation.getReal() > 0.0) {
            FieldAbsoluteDate<T> date = state.getDate();
            FieldGeodeticPoint<T> geo = baseFrame.getPoint(date.getField());
            CalculusFieldElement azimuth = FastMath.atan2((CalculusFieldElement)position.getX(), (CalculusFieldElement)position.getY());
            if (azimuth.getReal() < 0.0) {
                azimuth = (CalculusFieldElement)azimuth.add(Math.PI * 2);
            }
            return (T)this.pathDelay(date, geo, elevation, azimuth, frequency, (CalculusFieldElement[])parameters);
        }
        return (T)((CalculusFieldElement)elevation.getField().getZero());
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

