/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class GlobalIonosphereMapModel
implements IonosphericModel {
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private TimeSpanMap<TECMapPair> tecMap;
    private final TimeScale utc;
    private String names;

    @DefaultDataContext
    public GlobalIonosphereMapModel(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public GlobalIonosphereMapModel(String supportedNames, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this.utc = utc;
        this.tecMap = new TimeSpanMap<Object>(null);
        this.names = "";
        dataProvidersManager.feed(supportedNames, new Parser());
    }

    public GlobalIonosphereMapModel(TimeScale utc, DataSource ... ionex) {
        try {
            this.utc = utc;
            this.tecMap = new TimeSpanMap<Object>(null);
            this.names = "";
            Parser parser = new Parser();
            for (DataSource source : ionex) {
                try (InputStream is = source.getOpener().openStreamOnce();
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    parser.loadData(bis, source.getName());
                }
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    private double pathDelayAtIPP(AbsoluteDate date, GeodeticPoint piercePoint, double elevation, double frequency) {
        double stec;
        TECMapPair pair = this.getPairAtDate(date);
        double tec = pair.getTEC(date, piercePoint);
        double freq2 = frequency * frequency;
        if (pair.mapping) {
            stec = tec;
        } else {
            double fz = this.mappingFunction(elevation, pair.r0, pair.h);
            stec = tec * fz;
        }
        double alpha = 4.03E17 / freq2;
        return alpha * stec;
    }

    @Override
    public double pathDelay(SpacecraftState state, TopocentricFrame baseFrame, double frequency, double[] parameters) {
        Frame bodyFrame = baseFrame.getParentShape().getBodyFrame();
        Vector3D satPoint = state.getPosition(bodyFrame);
        double elevation = bodyFrame.getStaticTransformTo((Frame)baseFrame, state.getDate()).transformPosition(satPoint).getDelta();
        if (elevation > 0.0) {
            Vector3D los = (Vector3D)satPoint.subtract((Vector)baseFrame.getCartesianPoint()).normalize();
            GeodeticPoint ipp = this.piercePoint(state.getDate(), baseFrame.getCartesianPoint(), los, baseFrame.getParentShape());
            if (ipp != null) {
                return this.pathDelayAtIPP(state.getDate(), ipp, elevation, frequency);
            }
        }
        return 0.0;
    }

    private <T extends CalculusFieldElement<T>> T pathDelayAtIPP(FieldAbsoluteDate<T> date, GeodeticPoint piercePoint, T elevation, double frequency) {
        Object stec;
        TECMapPair pair = this.getPairAtDate(date.toAbsoluteDate());
        T tec = pair.getTEC(date, piercePoint);
        double freq2 = frequency * frequency;
        if (pair.mapping) {
            stec = tec;
        } else {
            T fz = this.mappingFunction(elevation, pair.r0, pair.h);
            stec = (CalculusFieldElement)tec.multiply(fz);
        }
        double alpha = 4.03E17 / freq2;
        return (T)((CalculusFieldElement)stec.multiply(alpha));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(FieldSpacecraftState<T> state, TopocentricFrame baseFrame, double frequency, T[] parameters) {
        Frame bodyFrame = baseFrame.getParentShape().getBodyFrame();
        FieldVector3D<T> satPoint = state.getPosition(bodyFrame);
        CalculusFieldElement elevation = bodyFrame.getStaticTransformTo((Frame)baseFrame, state.getDate()).transformPosition(satPoint).getDelta();
        if (elevation.getReal() > 0.0) {
            Vector3D los = (Vector3D)satPoint.toVector3D().subtract((Vector)baseFrame.getCartesianPoint()).normalize();
            GeodeticPoint ipp = this.piercePoint(state.getDate().toAbsoluteDate(), baseFrame.getCartesianPoint(), los, baseFrame.getParentShape());
            if (ipp != null) {
                return (T)this.pathDelayAtIPP(state.getDate(), ipp, elevation, frequency);
            }
        }
        return (T)((CalculusFieldElement)elevation.getField().getZero());
    }

    private TECMapPair getPairAtDate(AbsoluteDate date) {
        TECMapPair pair = this.tecMap.get(date);
        if (pair == null) {
            throw new OrekitException((Localizable)OrekitMessages.NO_TEC_DATA_IN_FILES_FOR_DATE, this.names, date);
        }
        return pair;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double mappingFunction(double elevation, double r0, double h) {
        double z = FastMath.abs((double)(1.5707963267948966 - elevation));
        double ratio = r0 / (r0 + h);
        double coef = FastMath.sin((double)z) * ratio;
        double fz = 1.0 / FastMath.sqrt((double)(1.0 - coef * coef));
        return fz;
    }

    private <T extends CalculusFieldElement<T>> T mappingFunction(T elevation, double r0, double h) {
        CalculusFieldElement z = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)elevation.getPi()).multiply(0.5)).subtract(elevation)));
        double ratio = r0 / (r0 + h);
        CalculusFieldElement coef = (CalculusFieldElement)FastMath.sin((CalculusFieldElement)z).multiply(ratio);
        CalculusFieldElement fz = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)coef.multiply((FieldElement)coef)).negate()).add(1.0))).reciprocal();
        return (T)fz;
    }

    private GeodeticPoint piercePoint(AbsoluteDate date, Vector3D recPoint, Vector3D los, BodyShape bodyShape) {
        TECMapPair pair = this.getPairAtDate(date);
        double r = pair.r0 + pair.h;
        double r2 = r * r;
        double p2 = recPoint.getNormSq();
        if (p2 >= r2) {
            return null;
        }
        double dot = Vector3D.dotProduct((Vector3D)recPoint, (Vector3D)los);
        double k = FastMath.sqrt((double)(dot * dot + r2 - p2)) - dot;
        Vector3D ipp = new Vector3D(1.0, recPoint, k, los);
        return bodyShape.transform(ipp, bodyShape.getBodyFrame(), null);
    }

    private static class IONEXHeader {
        private int nbOfMaps;
        private double baseRadius;
        private double hIon;
        private boolean isMappingFunction;

        IONEXHeader(int nbOfMaps, double baseRadius, double hIon, boolean mappingFunction) {
            this.nbOfMaps = nbOfMaps;
            this.baseRadius = baseRadius;
            this.hIon = hIon;
            this.isMappingFunction = mappingFunction;
        }

        public int getTECMapsNumer() {
            return this.nbOfMaps;
        }

        public double getEarthRadius() {
            return this.baseRadius;
        }

        public double getHIon() {
            return this.hIon;
        }

        public boolean isMappingFunction() {
            return this.isMappingFunction;
        }
    }

    private static class TECMapPair {
        private final TECMap first;
        private final TECMap second;
        private double r0;
        private double h;
        private boolean mapping;

        TECMapPair(TECMap first, TECMap second, double r0, double h, boolean mapping) {
            this.first = first;
            this.second = second;
            this.r0 = r0;
            this.h = h;
            this.mapping = mapping;
        }

        public double getTEC(AbsoluteDate date, GeodeticPoint ipp) {
            AbsoluteDate t1 = this.first.date;
            double tec1 = this.first.tec.value(ipp.getLatitude(), ipp.getLongitude());
            AbsoluteDate t2 = this.second.date;
            double tec2 = this.second.tec.value(ipp.getLatitude(), ipp.getLongitude());
            double dt = t2.durationFrom(t1);
            return t2.durationFrom(date) / dt * tec1 + date.durationFrom(t1) / dt * tec2;
        }

        public <T extends CalculusFieldElement<T>> T getTEC(FieldAbsoluteDate<T> date, GeodeticPoint ipp) {
            AbsoluteDate t1 = this.first.date;
            double tec1 = this.first.tec.value(ipp.getLatitude(), ipp.getLongitude());
            AbsoluteDate t2 = this.second.date;
            double tec2 = this.second.tec.value(ipp.getLatitude(), ipp.getLongitude());
            double dt = t2.durationFrom(t1);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)date.durationFrom(t2).negate()).divide(dt)).multiply(tec1)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)date.durationFrom(t1).divide(dt)).multiply(tec2))));
        }
    }

    private static class TECMap {
        private AbsoluteDate date;
        private BilinearInterpolatingFunction tec;

        TECMap(AbsoluteDate date, BilinearInterpolatingFunction tec) {
            this.date = date;
            this.tec = tec;
        }
    }

    private class Parser
    implements DataLoader {
        private static final String END = "END OF TEC MAP";
        private static final String EPOCH = "EPOCH OF CURRENT MAP";
        private static final int LABEL_START = 60;
        private static final double KM_TO_M = 1000.0;
        private IONEXHeader header;
        private List<TECMap> maps;

        private Parser() {
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException {
            this.maps = new ArrayList<TECMap>();
            int lineNumber = 0;
            String line = null;
            try (InputStreamReader isr = new InputStreamReader(input, StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                int nbOfMaps = 1;
                int exponent = -1;
                double baseRadius = Double.NaN;
                double hIon = Double.NaN;
                boolean mappingF = false;
                boolean inTEC = false;
                double[] latitudes = null;
                double[] longitudes = null;
                AbsoluteDate firstEpoch = null;
                AbsoluteDate lastEpoch = null;
                AbsoluteDate epoch = firstEpoch;
                ArrayList<Double> values = new ArrayList<Double>();
                line = br.readLine();
                while (line != null) {
                    block55: {
                        block54: {
                            ++lineNumber;
                            if (line.length() <= 60) break block54;
                            switch (line.substring(60).trim()) {
                                case "EPOCH OF FIRST MAP": {
                                    firstEpoch = this.parseDate(line);
                                    break;
                                }
                                case "EPOCH OF LAST MAP": {
                                    lastEpoch = this.parseDate(line);
                                    break;
                                }
                                case "INTERVAL": {
                                    break;
                                }
                                case "# OF MAPS IN FILE": {
                                    nbOfMaps = this.parseInt(line, 2, 4);
                                    break;
                                }
                                case "BASE RADIUS": {
                                    baseRadius = this.parseDouble(line, 2, 6) * 1000.0;
                                    break;
                                }
                                case "MAPPING FUNCTION": {
                                    mappingF = !this.parseString(line, 2, 4).equals("NONE");
                                    break;
                                }
                                case "EXPONENT": {
                                    exponent = this.parseInt(line, 4, 2);
                                    break;
                                }
                                case "HGT1 / HGT2 / DHGT": {
                                    if (this.parseDouble(line, 17, 3) == 0.0) {
                                        hIon = this.parseDouble(line, 3, 5) * 1000.0;
                                        break;
                                    }
                                    break block55;
                                }
                                case "LAT1 / LAT2 / DLAT": {
                                    latitudes = this.parseCoordinate(line);
                                    break;
                                }
                                case "LON1 / LON2 / DLON": {
                                    longitudes = this.parseCoordinate(line);
                                    break;
                                }
                                case "END OF HEADER": {
                                    if (latitudes == null || longitudes == null) {
                                        throw new OrekitException((Localizable)OrekitMessages.NO_LATITUDE_LONGITUDE_BONDARIES_IN_IONEX_HEADER, name);
                                    }
                                    if (firstEpoch == null || lastEpoch == null) {
                                        throw new OrekitException((Localizable)OrekitMessages.NO_EPOCH_IN_IONEX_HEADER, name);
                                    }
                                    this.header = new IONEXHeader(nbOfMaps, baseRadius, hIon, mappingF);
                                    break;
                                }
                                case "START OF TEC MAP": {
                                    inTEC = true;
                                    break;
                                }
                                case "END OF TEC MAP": {
                                    BilinearInterpolatingFunction tec = this.interpolateTEC(values, exponent, latitudes, longitudes);
                                    TECMap map = new TECMap(epoch, tec);
                                    this.maps.add(map);
                                    inTEC = false;
                                    values = new ArrayList();
                                    epoch = null;
                                    break;
                                }
                                default: {
                                    String[] readLine;
                                    if (!inTEC) break block55;
                                    if (line.endsWith(EPOCH)) {
                                        epoch = this.parseDate(line);
                                    }
                                    if (line.endsWith("LAT/LON1/LON2/DLON/H") || line.endsWith(END) || line.endsWith(EPOCH)) break block55;
                                    line = line.trim();
                                    for (String s : readLine = SEPARATOR.split(line)) {
                                        values.add(Double.parseDouble(s));
                                    }
                                    break block55;
                                }
                            }
                            break block55;
                        }
                        if (inTEC) {
                            String[] readLine;
                            line = line.trim();
                            for (String s : readLine = SEPARATOR.split(line)) {
                                values.add(Double.parseDouble(s));
                            }
                        }
                    }
                    line = br.readLine();
                }
                input.close();
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            if (this.maps.size() != this.header.getTECMapsNumer()) {
                throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_NUMBER_OF_TEC_MAPS_IN_FILE, this.maps.size(), this.header.getTECMapsNumer());
            }
            TECMap previous = null;
            for (TECMap current : this.maps) {
                if (previous != null) {
                    GlobalIonosphereMapModel.this.tecMap.addValidBetween(new TECMapPair(previous, current, this.header.getEarthRadius(), this.header.getHIon(), this.header.isMappingFunction()), previous.date, current.date);
                }
                previous = current;
            }
            GlobalIonosphereMapModel.this.names = GlobalIonosphereMapModel.this.names.isEmpty() ? name : GlobalIonosphereMapModel.this.names + ", " + name;
        }

        private String parseString(String line, int start, int length) {
            return line.substring(start, FastMath.min((int)line.length(), (int)(start + length))).trim();
        }

        private int parseInt(String line, int start, int length) {
            return Integer.parseInt(this.parseString(line, start, length));
        }

        private double parseDouble(String line, int start, int length) {
            return Double.parseDouble(this.parseString(line, start, length));
        }

        private AbsoluteDate parseDate(String line) {
            return new AbsoluteDate(this.parseInt(line, 0, 6), this.parseInt(line, 6, 6), this.parseInt(line, 12, 6), this.parseInt(line, 18, 6), this.parseInt(line, 24, 6), this.parseDouble(line, 30, 13), GlobalIonosphereMapModel.this.utc);
        }

        private double[] parseCoordinate(String line) {
            double a = this.parseDouble(line, 2, 6);
            double b = this.parseDouble(line, 8, 6);
            double c = this.parseDouble(line, 14, 6);
            double[] coordinate = new double[(int)FastMath.abs((double)((a - b) / c)) + 1];
            int i = 0;
            for (double cor = FastMath.min((double)a, (double)b); cor <= FastMath.max((double)a, (double)b); cor += FastMath.abs((double)c)) {
                coordinate[i] = FastMath.toRadians((double)cor);
                ++i;
            }
            return coordinate;
        }

        private BilinearInterpolatingFunction interpolateTEC(ArrayList<Double> values, double exponent, double[] latitudes, double[] longitudes) {
            int dimLat = latitudes.length;
            int dimLon = longitudes.length;
            double factor = FastMath.pow((double)10.0, (double)exponent);
            double[][] fvalTEC = new double[dimLat][dimLon];
            int index = dimLon * dimLat;
            for (int x = 0; x < dimLat; ++x) {
                for (int y = dimLon - 1; y >= 0; --y) {
                    fvalTEC[x][y] = values.get(--index) * factor;
                }
            }
            return new BilinearInterpolatingFunction(latitudes, longitudes, fvalTEC);
        }
    }
}

