/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;

class FieldNeQuickParameters<T extends CalculusFieldElement<T>> {
    private static final double X0 = 86.23292796211615;
    private final T nmF2;
    private final T hmF2;
    private final T hmF1;
    private final T hmE;
    private final T b2Bot;
    private final T b1Top;
    private final T b1Bot;
    private final T beTop;
    private final T beBot;
    private final T h0;
    private final T[] amplitudes;

    FieldNeQuickParameters(DateTimeComponents dateTime, double[] flattenF2, double[] flattenFm3, T latitude, T longitude, double[] alpha, double[][] modipGrip) {
        CalculusFieldElement nmF1;
        CalculusFieldElement zero = (CalculusFieldElement)latitude.getField().getZero();
        T modip = this.computeMODIP(latitude, longitude, modipGrip);
        T az = this.computeAz(modip, alpha);
        CalculusFieldElement azr = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)az.subtract(63.7)).multiply(1123.6)).add(167273.0))).subtract(408.99);
        DateComponents date = dateTime.getDate();
        TimeComponents time = dateTime.getTime();
        double hours = time.getSecondsInUTCDay() / 3600.0;
        T xeff = this.computeEffectiveSolarAngle(date.getMonth(), hours, latitude, longitude);
        this.hmE = (CalculusFieldElement)zero.newInstance(120.0);
        T foE = this.computefoE(date.getMonth(), az, xeff, latitude);
        CalculusFieldElement nmE = (CalculusFieldElement)((CalculusFieldElement)foE.multiply(foE)).multiply(0.124);
        double t = FastMath.toRadians((double)(15.0 * hours)) - Math.PI;
        CalculusFieldElement[] scT = this.sinCos((CalculusFieldElement)zero.newInstance(t), 6);
        CalculusFieldElement[] cf2 = this.computeCF2(flattenF2, azr, scT);
        CalculusFieldElement[] cm3 = this.computeCm3(flattenFm3, azr, scT);
        CalculusFieldElement[] scL = this.sinCos((CalculusFieldElement)longitude, 8);
        CalculusFieldElement foF2 = this.computefoF2((CalculusFieldElement)modip, cf2, (CalculusFieldElement)latitude, scL);
        CalculusFieldElement mF2 = this.computeMF2((CalculusFieldElement)modip, cm3, (CalculusFieldElement)latitude, scL);
        this.nmF2 = (CalculusFieldElement)((CalculusFieldElement)foF2.multiply((FieldElement)foF2)).multiply(0.124);
        this.hmF2 = this.computehmF2(foE, foF2, mF2);
        CalculusFieldElement foF1 = this.computefoF1(foE, foF2);
        if (foF1.getReal() <= 0.0 && foE.getReal() > 2.0) {
            CalculusFieldElement foEpopf = (CalculusFieldElement)foE.add(0.5);
            nmF1 = (CalculusFieldElement)((CalculusFieldElement)foEpopf.multiply((FieldElement)foEpopf)).multiply(0.124);
        } else {
            nmF1 = (CalculusFieldElement)((CalculusFieldElement)foF1.multiply((FieldElement)foF1)).multiply(0.124);
        }
        this.hmF1 = (CalculusFieldElement)((CalculusFieldElement)this.hmF2.add(this.hmE)).multiply(0.5);
        CalculusFieldElement a = (CalculusFieldElement)this.clipExp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.log((CalculusFieldElement)((CalculusFieldElement)foF2.multiply((FieldElement)foF2))).multiply(0.857)).add((FieldElement)((CalculusFieldElement)FastMath.log((CalculusFieldElement)mF2).multiply(2.02)))).add(-3.467)).multiply(0.01);
        this.b2Bot = (CalculusFieldElement)((CalculusFieldElement)this.nmF2.divide((FieldElement)a)).multiply(0.385);
        this.b1Top = (CalculusFieldElement)((CalculusFieldElement)this.hmF2.subtract(this.hmF1)).multiply(0.3);
        this.b1Bot = (CalculusFieldElement)((CalculusFieldElement)this.hmF1.subtract(this.hmE)).multiply(0.5);
        this.beTop = FastMath.max(this.b1Bot, (CalculusFieldElement)((CalculusFieldElement)zero.newInstance(7.0)));
        this.beBot = (CalculusFieldElement)zero.newInstance(5.0);
        this.amplitudes = this.computeLayerAmplitudes(nmE, nmF1, foF1);
        this.h0 = this.computeH0(date.getMonth(), azr);
    }

    public T getNmF2() {
        return this.nmF2;
    }

    public T getHmF2() {
        return this.hmF2;
    }

    public T getHmF1() {
        return this.hmF1;
    }

    public T getHmE() {
        return this.hmE;
    }

    public T getB2Bot() {
        return this.b2Bot;
    }

    public T getB1Top() {
        return this.b1Top;
    }

    public T getB1Bot() {
        return this.b1Bot;
    }

    public T getBEBot() {
        return this.beBot;
    }

    public T getBETop() {
        return this.beTop;
    }

    public T[] getLayerAmplitudes() {
        return (CalculusFieldElement[])this.amplitudes.clone();
    }

    public T getH0() {
        return this.h0;
    }

    private T computeMODIP(T lat, T lon, double[][] stModip) {
        CalculusFieldElement zero = (CalculusFieldElement)lat.getField().getZero();
        CalculusFieldElement latitude = FastMath.toDegrees(lat);
        CalculusFieldElement longitude = FastMath.toDegrees(lon);
        if (latitude.getReal() == 90.0 || latitude.getReal() == -90.0) {
            return (T)latitude;
        }
        int lF = (int)((longitude.getReal() + 180.0) * 0.1);
        int l = lF - 2;
        if (l < -2) {
            l += 36;
        } else if (l > 33) {
            l -= 36;
        }
        CalculusFieldElement a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)latitude.add(90.0)).multiply(0.2)).add(1.0);
        CalculusFieldElement aF = FastMath.floor((CalculusFieldElement)a);
        CalculusFieldElement x = (CalculusFieldElement)a.subtract((FieldElement)aF);
        int i = (int)aF.getReal() - 2;
        CalculusFieldElement z1 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 2]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 2]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 2]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 2]), x);
        CalculusFieldElement z2 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 3]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 3]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 3]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 3]), x);
        CalculusFieldElement z3 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 4]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 4]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 4]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 4]), x);
        CalculusFieldElement z4 = this.interpolate((CalculusFieldElement)zero.add(stModip[i + 1][l + 5]), (CalculusFieldElement)zero.add(stModip[i + 2][l + 5]), (CalculusFieldElement)zero.add(stModip[i + 3][l + 5]), (CalculusFieldElement)zero.add(stModip[i + 4][l + 5]), x);
        CalculusFieldElement b = (CalculusFieldElement)((CalculusFieldElement)longitude.add(180.0)).multiply(0.1);
        CalculusFieldElement bF = FastMath.floor((CalculusFieldElement)b);
        CalculusFieldElement y = (CalculusFieldElement)b.subtract((FieldElement)bF);
        return (T)this.interpolate(z1, z2, z3, z4, y);
    }

    private T computeAz(T modip, double[] alpha) {
        Field field = modip.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        if (alpha[0] == 0.0 && alpha[1] == 0.0 && alpha[2] == 0.0) {
            return (T)((CalculusFieldElement)zero.newInstance(63.7));
        }
        CalculusFieldElement az = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)modip.multiply(alpha[2])).add(alpha[1])).multiply(modip)).add(alpha[0]);
        az = FastMath.max((CalculusFieldElement)zero, (CalculusFieldElement)az);
        az = FastMath.min((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(400.0)), (CalculusFieldElement)az);
        return (T)az;
    }

    private T computeEffectiveSolarAngle(int month, double hours, T latitude, T longitude) {
        CalculusFieldElement zero = (CalculusFieldElement)latitude.getField().getZero();
        CalculusFieldElement lt = (CalculusFieldElement)((CalculusFieldElement)longitude.divide(FastMath.toRadians((double)15.0))).add(hours);
        double dy = 30.5 * (double)month - 15.0;
        double t = dy + (18.0 - hours) / 24.0;
        double am = FastMath.toRadians((double)(0.9856 * t - 3.289));
        double al = am + FastMath.toRadians((double)(1.916 * FastMath.sin((double)am) + 0.02 * FastMath.sin((double)(2.0 * am)) + 282.634));
        double sDec = 0.39782 * FastMath.sin((double)al);
        double cDec = FastMath.sqrt((double)(1.0 - sDec * sDec));
        FieldSinCos scLat = FastMath.sinCos(latitude);
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)lt.negate()).add(12.0)).multiply(0.2617993877991494);
        CalculusFieldElement cZenith = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scLat.sin()).multiply(sDec)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scLat.cos()).multiply(cDec)).multiply((FieldElement)FastMath.cos((CalculusFieldElement)coef))));
        CalculusFieldElement angle = FastMath.atan2((CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cZenith.multiply((FieldElement)cZenith)).negate()).add(1.0))), (CalculusFieldElement)cZenith);
        CalculusFieldElement x = FastMath.toDegrees((CalculusFieldElement)angle);
        CalculusFieldElement xeff = this.join((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.clipExp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(0.2)).negate()).add(20.0)).multiply(0.24)).negate()).add(90.0), x, (CalculusFieldElement)zero.newInstance(12.0), (CalculusFieldElement)x.subtract(86.23292796211615));
        return (T)FastMath.toRadians((CalculusFieldElement)xeff);
    }

    private T computefoE(int month, T az, T xeff, T latitude) {
        CalculusFieldElement lat = FastMath.toDegrees(latitude);
        CalculusFieldElement sqAz = FastMath.sqrt(az);
        int seas = month == 1 || month == 2 || month == 11 || month == 12 ? -1 : (month == 3 || month == 4 || month == 9 || month == 10 ? 0 : 1);
        CalculusFieldElement ee = this.clipExp((CalculusFieldElement)lat.multiply(0.3));
        CalculusFieldElement seasp = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ee.subtract(1.0)).divide((FieldElement)((CalculusFieldElement)ee.add(1.0)))).multiply(seas);
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)seasp.multiply(0.019)).negate()).add(1.112);
        return (T)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)coef.multiply((FieldElement)coef)).multiply((FieldElement)sqAz)).multiply((FieldElement)((CalculusFieldElement)FastMath.cos(xeff).pow(0.6)))).add(0.49)));
    }

    private T computehmF2(T foE, T foF2, T mF2) {
        CalculusFieldElement zero = (CalculusFieldElement)foE.getField().getZero();
        CalculusFieldElement fo = (CalculusFieldElement)foF2.divide(foE);
        CalculusFieldElement ratio = this.join(fo, (CalculusFieldElement)zero.newInstance(1.75), (CalculusFieldElement)zero.newInstance(20.0), (CalculusFieldElement)fo.subtract(1.75));
        CalculusFieldElement deltaM = (CalculusFieldElement)zero.subtract(0.012);
        if (foE.getReal() >= 1.0E-30) {
            deltaM = (CalculusFieldElement)deltaM.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ratio.subtract(1.215)).divide(0.253)).reciprocal()));
        }
        CalculusFieldElement mF2Sq = (CalculusFieldElement)mF2.square();
        CalculusFieldElement temp = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mF2Sq.multiply(0.0196)).add(1.0)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)mF2Sq.multiply(1.2967)).subtract(1.0)))));
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mF2.multiply(1490.0)).multiply((FieldElement)temp)).divide((FieldElement)((CalculusFieldElement)mF2.add((FieldElement)deltaM)))).subtract(176.0));
    }

    private T[] sinCos(T a, int n) {
        FieldSinCos sc0;
        FieldSinCos sci = sc0 = FastMath.sinCos(a);
        CalculusFieldElement[] sc = (CalculusFieldElement[])MathArrays.buildArray((Field)a.getField(), (int)(2 * n));
        int isc = 0;
        sc[isc++] = (CalculusFieldElement)sci.sin();
        sc[isc++] = (CalculusFieldElement)sci.cos();
        for (int i = 1; i < n; ++i) {
            sci = FieldSinCos.sum((FieldSinCos)sc0, (FieldSinCos)sci);
            sc[isc++] = (CalculusFieldElement)sci.sin();
            sc[isc++] = (CalculusFieldElement)sci.cos();
        }
        return sc;
    }

    private T[] computeCF2(double[] flattenF2, T azr, T[] scT) {
        CalculusFieldElement azr01 = (CalculusFieldElement)azr.multiply(0.01);
        CalculusFieldElement omazr01 = (CalculusFieldElement)((CalculusFieldElement)azr01.negate()).add(1.0);
        CalculusFieldElement[] cf2 = (CalculusFieldElement[])MathArrays.buildArray((Field)azr.getField(), (int)76);
        int index = 0;
        for (int i = 0; i < cf2.length; ++i) {
            cf2[i] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 1])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 2])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 3])))).multiply(scT[0])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 4])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 5])))).multiply(scT[1])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 6])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 7])))).multiply(scT[2])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 8])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 9])))).multiply(scT[3])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 10])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 11])))).multiply(scT[4])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 12])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 13])))).multiply(scT[5])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 14])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 15])))).multiply(scT[6])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 16])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 17])))).multiply(scT[7])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 18])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 19])))).multiply(scT[8])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 20])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 21])))).multiply(scT[9])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 22])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 23])))).multiply(scT[10])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenF2[index + 24])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenF2[index + 25])))).multiply(scT[11])));
            index += 26;
        }
        return cf2;
    }

    private T[] computeCm3(double[] flattenFm3, T azr, T[] scT) {
        CalculusFieldElement azr01 = (CalculusFieldElement)azr.multiply(0.01);
        CalculusFieldElement omazr01 = (CalculusFieldElement)((CalculusFieldElement)azr01.negate()).add(1.0);
        CalculusFieldElement[] cm3 = (CalculusFieldElement[])MathArrays.buildArray((Field)azr.getField(), (int)49);
        int index = 0;
        for (int i = 0; i < cm3.length; ++i) {
            cm3[i] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 1])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 2])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 3])))).multiply(scT[0])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 4])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 5])))).multiply(scT[1])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 6])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 7])))).multiply(scT[2])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 8])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 9])))).multiply(scT[3])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 10])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 11])))).multiply(scT[4])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 12])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 13])))).multiply(scT[5])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 14])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 15])))).multiply(scT[6])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)omazr01.multiply(flattenFm3[index + 16])).add((FieldElement)((CalculusFieldElement)azr01.multiply(flattenFm3[index + 17])))).multiply(scT[7])));
            index += 18;
        }
        return cm3;
    }

    private T computefoF2(T modip, T[] cf2, T latitude, T[] scL) {
        CalculusFieldElement cosLat1;
        int[] q = new int[]{12, 12, 9, 5, 2, 1, 1, 1, 1};
        Object frequency = cf2[0];
        CalculusFieldElement sinMODIP = FastMath.sin((CalculusFieldElement)FastMath.toRadians(modip));
        CalculusFieldElement[] m = (CalculusFieldElement[])MathArrays.buildArray((Field)latitude.getField(), (int)12);
        m[0] = (CalculusFieldElement)latitude.getField().getOne();
        for (int i = 1; i < q[0]; ++i) {
            m[i] = (CalculusFieldElement)sinMODIP.multiply((FieldElement)m[i - 1]);
            frequency = (CalculusFieldElement)frequency.add((FieldElement)((CalculusFieldElement)m[i].multiply(cf2[i])));
        }
        int index = 12;
        CalculusFieldElement cosLatI = cosLat1 = FastMath.cos(latitude);
        for (int i = 1; i < q.length; ++i) {
            CalculusFieldElement c = (CalculusFieldElement)cosLatI.multiply(scL[2 * i - 1]);
            CalculusFieldElement s = (CalculusFieldElement)cosLatI.multiply(scL[2 * i - 2]);
            for (int j = 0; j < q[i]; ++j) {
                frequency = (CalculusFieldElement)frequency.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)c)).multiply(cf2[index++])));
                frequency = (CalculusFieldElement)frequency.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)s)).multiply(cf2[index++])));
            }
            cosLatI = (CalculusFieldElement)cosLatI.multiply((FieldElement)cosLat1);
        }
        return frequency;
    }

    private T computeMF2(T modip, T[] cm3, T latitude, T[] scL) {
        CalculusFieldElement cosLat1;
        int[] r = new int[]{7, 8, 6, 3, 2, 1, 1};
        Object m3000 = cm3[0];
        CalculusFieldElement sinMODIP = FastMath.sin((CalculusFieldElement)FastMath.toRadians(modip));
        CalculusFieldElement[] m = (CalculusFieldElement[])MathArrays.buildArray((Field)latitude.getField(), (int)12);
        m[0] = (CalculusFieldElement)latitude.getField().getOne();
        for (int i = 1; i < 12; ++i) {
            m[i] = (CalculusFieldElement)sinMODIP.multiply((FieldElement)m[i - 1]);
            if (i >= 7) continue;
            m3000 = (CalculusFieldElement)m3000.add((FieldElement)((CalculusFieldElement)m[i].multiply(cm3[i])));
        }
        int index = 7;
        CalculusFieldElement cosLatI = cosLat1 = FastMath.cos(latitude);
        for (int i = 1; i < r.length; ++i) {
            CalculusFieldElement c = (CalculusFieldElement)cosLatI.multiply(scL[2 * i - 1]);
            CalculusFieldElement s = (CalculusFieldElement)cosLatI.multiply(scL[2 * i - 2]);
            for (int j = 0; j < r[i]; ++j) {
                m3000 = (CalculusFieldElement)m3000.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)c)).multiply(cm3[index++])));
                m3000 = (CalculusFieldElement)m3000.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m[j].multiply((FieldElement)s)).multiply(cm3[index++])));
            }
            cosLatI = (CalculusFieldElement)cosLatI.multiply((FieldElement)cosLat1);
        }
        return m3000;
    }

    private T computefoF1(T foE, T foF2) {
        CalculusFieldElement temp;
        CalculusFieldElement zero = (CalculusFieldElement)foE.getField().getZero();
        CalculusFieldElement temp2 = this.join(zero, temp = this.join((CalculusFieldElement)foE.multiply(1.4), zero, (CalculusFieldElement)zero.newInstance(1000.0), (CalculusFieldElement)foE.subtract(2.0)), (CalculusFieldElement)zero.newInstance(1000.0), (CalculusFieldElement)foE.subtract((FieldElement)temp));
        CalculusFieldElement value = this.join(temp2, (CalculusFieldElement)temp2.multiply(0.85), (CalculusFieldElement)zero.newInstance(60.0), (CalculusFieldElement)((CalculusFieldElement)foF2.multiply(0.85)).subtract((FieldElement)temp2));
        if (value.getReal() < 1.0E-6) {
            return (T)zero;
        }
        return (T)value;
    }

    private T[] computeLayerAmplitudes(T nmE, T nmF1, T foF1) {
        CalculusFieldElement a1;
        CalculusFieldElement zero = (CalculusFieldElement)nmE.getField().getZero();
        CalculusFieldElement[] amplitude = (CalculusFieldElement[])MathArrays.buildArray((Field)nmE.getField(), (int)3);
        amplitude[0] = a1 = (CalculusFieldElement)this.nmF2.multiply(4.0);
        if (foF1.getReal() < 0.5) {
            amplitude[1] = zero;
            amplitude[2] = (CalculusFieldElement)((CalculusFieldElement)nmE.subtract((FieldElement)this.epst(a1, this.hmF2, this.b2Bot, this.hmE))).multiply(4.0);
        } else {
            CalculusFieldElement a2a = zero;
            CalculusFieldElement a3a = (CalculusFieldElement)nmE.multiply(4.0);
            for (int i = 0; i < 5; ++i) {
                a2a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)nmF1.subtract((FieldElement)this.epst(a1, this.hmF2, this.b2Bot, this.hmF1))).subtract((FieldElement)this.epst(a3a, this.hmE, this.beTop, this.hmF1))).multiply(4.0);
                a2a = this.join(a2a, (CalculusFieldElement)nmF1.multiply(0.8), (CalculusFieldElement)nmE.getField().getOne(), (CalculusFieldElement)a2a.subtract((FieldElement)((CalculusFieldElement)nmF1.multiply(0.8))));
                a3a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)nmE.subtract((FieldElement)this.epst(a2a, this.hmF1, this.b1Bot, this.hmE))).subtract((FieldElement)this.epst(a1, this.hmF2, this.b2Bot, this.hmE))).multiply(4.0);
            }
            amplitude[1] = a2a;
            amplitude[2] = this.join(a3a, (CalculusFieldElement)zero.newInstance(0.05), (CalculusFieldElement)zero.newInstance(60.0), (CalculusFieldElement)a3a.subtract(0.005));
        }
        return amplitude;
    }

    private T computeH0(int month, T azr) {
        CalculusFieldElement ka;
        CalculusFieldElement one = (CalculusFieldElement)azr.getField().getOne();
        if (month > 3 && month < 10) {
            ka = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)azr.multiply(0.014)).add((FieldElement)((CalculusFieldElement)this.hmF2.multiply(0.008)))).negate()).add(6.705);
        } else {
            CalculusFieldElement ratio = (CalculusFieldElement)this.hmF2.divide(this.b2Bot);
            ka = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ratio.multiply((FieldElement)ratio)).multiply(0.097)).add((FieldElement)((CalculusFieldElement)this.nmF2.multiply(0.153)))).add(-7.77);
        }
        CalculusFieldElement kb = this.join(ka, (CalculusFieldElement)one.newInstance(2.0), one, (CalculusFieldElement)ka.subtract(2.0));
        kb = this.join((CalculusFieldElement)one.newInstance(8.0), kb, one, (CalculusFieldElement)kb.subtract(8.0));
        CalculusFieldElement hA = (CalculusFieldElement)kb.multiply(this.b2Bot);
        CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)hA.subtract(150.0)).multiply(0.01);
        CalculusFieldElement v = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(0.041163)).subtract(0.183981)).multiply((FieldElement)x)).add(1.424472);
        return (T)((CalculusFieldElement)hA.divide((FieldElement)v));
    }

    private T clipExp(T power) {
        CalculusFieldElement zero = (CalculusFieldElement)power.getField().getZero();
        if (power.getReal() > 80.0) {
            return (T)((CalculusFieldElement)zero.newInstance(5.5406E34));
        }
        if (power.getReal() < -80.0) {
            return (T)((CalculusFieldElement)zero.newInstance(1.8049E-35));
        }
        return (T)FastMath.exp(power);
    }

    private T interpolate(T z1, T z2, T z3, T z4, T x) {
        if (FastMath.abs((double)(2.0 * x.getReal())) < 1.0E-10) {
            return z2;
        }
        CalculusFieldElement delta = (CalculusFieldElement)((CalculusFieldElement)x.multiply(2.0)).subtract(1.0);
        CalculusFieldElement g1 = (CalculusFieldElement)z3.add(z2);
        CalculusFieldElement g2 = (CalculusFieldElement)z3.subtract(z2);
        CalculusFieldElement g3 = (CalculusFieldElement)z4.add(z1);
        CalculusFieldElement g4 = (CalculusFieldElement)((CalculusFieldElement)z4.subtract(z1)).divide(3.0);
        CalculusFieldElement a0 = (CalculusFieldElement)((CalculusFieldElement)g1.multiply(9.0)).subtract((FieldElement)g3);
        CalculusFieldElement a1 = (CalculusFieldElement)((CalculusFieldElement)g2.multiply(9.0)).subtract((FieldElement)g4);
        CalculusFieldElement a2 = (CalculusFieldElement)g3.subtract((FieldElement)g1);
        CalculusFieldElement a3 = (CalculusFieldElement)g4.subtract((FieldElement)g2);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)delta.multiply((FieldElement)a3)).add((FieldElement)a2)).multiply((FieldElement)delta)).add((FieldElement)a1)).multiply((FieldElement)delta)).add((FieldElement)a0)).multiply(0.0625));
    }

    private T join(T dF1, T dF2, T dA, T dX) {
        CalculusFieldElement ee = this.clipExp((CalculusFieldElement)dA.multiply(dX));
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dF1.multiply((FieldElement)ee)).add(dF2)).divide((FieldElement)((CalculusFieldElement)ee.add(1.0))));
    }

    private T epst(T x, T y, T z, T w) {
        CalculusFieldElement ex = this.clipExp((CalculusFieldElement)((CalculusFieldElement)w.subtract(y)).divide(z));
        CalculusFieldElement opex = (CalculusFieldElement)ex.add(1.0);
        return (T)((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ex)).divide((FieldElement)((CalculusFieldElement)opex.multiply((FieldElement)opex))));
    }
}

