/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.ionosphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.frames.TopocentricFrame;
import org.orekit.models.earth.ionosphere.IonosphericMappingFunction;
import org.orekit.models.earth.ionosphere.IonosphericModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class EstimatedIonosphericModel
implements IonosphericModel {
    public static final String VERTICAL_TOTAL_ELECTRON_CONTENT = "vertical total electron content";
    private static final double FACTOR = 4.03E17;
    private final transient IonosphericMappingFunction model;
    private final transient ParameterDriver vtec;

    public EstimatedIonosphericModel(IonosphericMappingFunction model, double vtecValue) {
        this.model = model;
        this.vtec = new ParameterDriver(VERTICAL_TOTAL_ELECTRON_CONTENT, vtecValue, FastMath.scalb((double)1.0, (int)3), 0.0, 1000.0);
    }

    @Override
    public double pathDelay(SpacecraftState state, TopocentricFrame baseFrame, double frequency, double[] parameters) {
        Vector3D position = state.getPosition(baseFrame);
        double elevation = position.getDelta();
        if (elevation > 0.0) {
            return this.pathDelay(elevation, frequency, parameters);
        }
        return 0.0;
    }

    public double pathDelay(double elevation, double frequency, double[] parameters) {
        double freq2 = frequency * frequency;
        double fz = this.model.mappingFactor(elevation);
        double stec = parameters[0] * fz;
        double alpha = 4.03E17 / freq2;
        return alpha * stec;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(FieldSpacecraftState<T> state, TopocentricFrame baseFrame, double frequency, T[] parameters) {
        FieldVector3D<T> position = state.getPosition(baseFrame);
        CalculusFieldElement elevation = position.getDelta();
        if (elevation.getReal() > 0.0) {
            return (T)this.pathDelay(elevation, frequency, (CalculusFieldElement[])parameters);
        }
        return (T)((CalculusFieldElement)elevation.getField().getZero());
    }

    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, double frequency, T[] parameters) {
        double freq2 = frequency * frequency;
        T fz = this.model.mappingFactor(elevation);
        CalculusFieldElement stec = (CalculusFieldElement)parameters[0].multiply(fz);
        double alpha = 4.03E17 / freq2;
        return (T)((CalculusFieldElement)stec.multiply(alpha));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.vtec);
    }
}

