/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.time.AbsoluteDate;

public class PsdCorrection {
    private final Axis axis;
    private final TimeEvolution evolution;
    private final AbsoluteDate earthquakeDate;
    private final double amplitude;
    private final double relaxationTime;

    public PsdCorrection(Axis axis, TimeEvolution evolution, AbsoluteDate earthquakeDate, double amplitude, double relaxationTime) {
        this.axis = axis;
        this.evolution = evolution;
        this.earthquakeDate = earthquakeDate;
        this.amplitude = amplitude;
        this.relaxationTime = relaxationTime;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public TimeEvolution getEvolution() {
        return this.evolution;
    }

    public AbsoluteDate getEarthquakeDate() {
        return this.earthquakeDate;
    }

    public double getAmplitude() {
        return this.amplitude;
    }

    public double getRelaxationTime() {
        return this.relaxationTime;
    }

    public Vector3D displacement(AbsoluteDate date, GeodeticPoint base) {
        double scaledTime = date.durationFrom(this.earthquakeDate) / this.relaxationTime;
        double timeFactor = this.evolution.timeFactor(scaledTime);
        return new Vector3D(this.amplitude * timeFactor, this.axis.vector(base));
    }

    public static enum TimeEvolution {
        EXP{

            @Override
            public double timeFactor(double scaledTime) {
                return 1.0 - FastMath.exp((double)(-scaledTime));
            }
        }
        ,
        LOG{

            @Override
            public double timeFactor(double scaledTime) {
                return FastMath.log((double)(1.0 + scaledTime));
            }
        };


        public abstract double timeFactor(double var1);
    }

    public static enum Axis {
        EAST{

            @Override
            public Vector3D vector(GeodeticPoint base) {
                return base.getEast();
            }
        }
        ,
        NORTH{

            @Override
            public Vector3D vector(GeodeticPoint base) {
                return base.getNorth();
            }
        }
        ,
        UP{

            @Override
            public Vector3D vector(GeodeticPoint base) {
                return base.getZenith();
            }
        };


        public abstract Vector3D vector(GeodeticPoint var1);
    }
}

