/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.BodiesElements;
import org.orekit.frames.Frame;
import org.orekit.models.earth.displacement.PsdCorrection;
import org.orekit.models.earth.displacement.StationDisplacement;
import org.orekit.utils.TimeSpanMap;

public class PostSeismicDeformation
implements StationDisplacement {
    private final GeodeticPoint base;
    private final TimeSpanMap<List<PsdCorrection>> corrections;

    public PostSeismicDeformation(GeodeticPoint base, TimeSpanMap<List<PsdCorrection>> corrections) {
        this.base = base;
        this.corrections = corrections;
    }

    @Override
    public Vector3D displacement(BodiesElements elements, Frame earthFrame, Vector3D referencePoint) {
        Vector3D cumulativeCorrection = Vector3D.ZERO;
        List<PsdCorrection> correctionsAtDate = this.corrections.get(elements.getDate());
        if (correctionsAtDate != null) {
            for (PsdCorrection correction : correctionsAtDate) {
                cumulativeCorrection = cumulativeCorrection.add((Vector)correction.displacement(elements.getDate(), this.base));
            }
        }
        return cumulativeCorrection;
    }
}

