/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.displacement.OceanLoadingCoefficients;
import org.orekit.models.earth.displacement.Tide;

public class OceanLoadingCoefficientsBlqParser {
    private static final String REAL_TYPE_PATTERN = "[-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?";
    private static final String REAL_FIELD_PATTERN = "\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)";
    private static final String END_OF_LINE_PATTERN = "\\p{Space}*$";
    private static final String SITE_LINE_PATTERN = "^\\$\\$ *([^,]*),\\p{Space}*(?:RADI TANG)?\\p{Space}*lon/lat:\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*$";
    private static final String DATA_LINE_PATTERN = "^\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*$";
    private static final Pattern SITE_PATTERN = Pattern.compile("^\\$\\$ *([^,]*),\\p{Space}*(?:RADI TANG)?\\p{Space}*lon/lat:\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*$");
    private static final Pattern DATA_PATTERN = Pattern.compile("^\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*([-+]?(?:\\p{Digit}+(?:\\.\\p{Digit}*)?|\\.\\p{Digit}+)(?:[eE][-+]?\\p{Digit}+)?)\\p{Space}*$");
    private static final Tide[][] TIDES = new Tide[][]{{Tide.SSA, Tide.MM, Tide.MF}, {Tide.Q1, Tide.O1, Tide.P1, Tide.K1}, {Tide.N2, Tide.M2, Tide.S2, Tide.K2}};
    private static final int[] I = new int[]{2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0};
    private static final int[] J = new int[]{1, 2, 0, 3, 3, 1, 2, 0, 2, 1, 0};

    public List<OceanLoadingCoefficients> parse(DataSource source) {
        ArrayList<OceanLoadingCoefficients> coefficients = new ArrayList<OceanLoadingCoefficients>();
        String siteName = null;
        GeodeticPoint siteLocation = null;
        double[][][] data = new double[6][3][];
        for (int i = 0; i < data.length; ++i) {
            data[i][0] = new double[3];
            data[i][1] = new double[4];
            data[i][2] = new double[4];
        }
        try (BufferedReader reader = new BufferedReader(source.getOpener().openReaderOnce());){
            int lineNumber = 0;
            int dataLine = -1;
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher;
                ++lineNumber;
                if (dataLine < 0) {
                    matcher = SITE_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        siteName = matcher.group(1);
                        siteLocation = new GeodeticPoint(FastMath.toRadians((double)Double.parseDouble(matcher.group(3))), FastMath.toRadians((double)Double.parseDouble(matcher.group(2))), Double.parseDouble(matcher.group(4)));
                        dataLine = 0;
                    }
                } else {
                    matcher = DATA_PATTERN.matcher(line);
                    if (!matcher.matches()) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, source.getName(), line);
                    }
                    for (int k = 0; k < I.length; ++k) {
                        data[dataLine][OceanLoadingCoefficientsBlqParser.I[k]][OceanLoadingCoefficientsBlqParser.J[k]] = dataLine < 3 ? Double.parseDouble(matcher.group(k + 1)) : -FastMath.toRadians((double)Double.parseDouble(matcher.group(k + 1)));
                    }
                    if (dataLine < data.length - 1) {
                        ++dataLine;
                    } else {
                        coefficients.add(new OceanLoadingCoefficients(siteName, siteLocation, TIDES, data[0], data[3], data[1], data[4], data[2], data[5]));
                        dataLine = -1;
                    }
                }
                line = reader.readLine();
            }
            if (dataLine >= 0) {
                throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, source.getName(), lineNumber);
            }
        }
        catch (IOException ioe) {
            throw new OrekitException(ioe, (Localizable)LocalizedCoreFormats.SIMPLE_MESSAGE, ioe.getLocalizedMessage());
        }
        return coefficients;
    }
}

