/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.displacement;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.displacement.OceanLoadingCoefficients;
import org.orekit.models.earth.displacement.OceanLoadingCoefficientsBlqParser;

public class OceanLoadingCoefficientsBLQFactory
extends AbstractSelfFeedingLoader {
    public static final String DEFAULT_BLQ_SUPPORTED_NAMES = "^.+\\.blq$";
    private final List<OceanLoadingCoefficients> coefficients = new ArrayList<OceanLoadingCoefficients>();

    @DefaultDataContext
    public OceanLoadingCoefficientsBLQFactory(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager());
    }

    public OceanLoadingCoefficientsBLQFactory(String supportedNames, DataProvidersManager dataProvidersManager) {
        super(supportedNames, dataProvidersManager);
    }

    private void loadsIfNeeded() {
        if (this.coefficients.isEmpty()) {
            this.feed(new DataLoader(){

                @Override
                public boolean stillAcceptsData() {
                    return true;
                }

                @Override
                public void loadData(InputStream input, String name) {
                    OceanLoadingCoefficientsBlqParser parser = new OceanLoadingCoefficientsBlqParser();
                    OceanLoadingCoefficientsBLQFactory.this.coefficients.addAll(parser.parse(new DataSource(name, () -> input)));
                }
            });
        }
    }

    public List<String> getSites() {
        this.loadsIfNeeded();
        return this.coefficients.stream().map(OceanLoadingCoefficients::getSiteName).sorted(String::compareToIgnoreCase).collect(Collectors.toList());
    }

    public OceanLoadingCoefficients getCoefficients(String site) {
        this.loadsIfNeeded();
        Optional<OceanLoadingCoefficients> optional = this.coefficients.stream().filter(c -> c.getSiteName().equalsIgnoreCase(site)).findFirst();
        if (!optional.isPresent()) {
            throw new OrekitException((Localizable)OrekitMessages.STATION_NOT_FOUND, site, String.join((CharSequence)", ", this.getSites()));
        }
        return optional.get();
    }
}

