/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.data.AbstractSolarActivityDataLoader;
import org.orekit.models.earth.atmosphere.data.MarshallSolarActivityFutureEstimation;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.DateComponents;
import org.orekit.time.Month;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public class MarshallSolarActivityFutureEstimationLoader
extends AbstractSolarActivityDataLoader<LineParameters> {
    private final Pattern dataPattern;
    private final SortedSet<TimeStamped> data = new TreeSet<TimeStamped>(new ChronologicalComparator());
    private final MarshallSolarActivityFutureEstimation.StrengthLevel strengthLevel;

    @DefaultDataContext
    public MarshallSolarActivityFutureEstimationLoader(MarshallSolarActivityFutureEstimation.StrengthLevel strengthLevel) {
        this(strengthLevel, DataContext.getDefault().getTimeScales().getUTC());
    }

    public MarshallSolarActivityFutureEstimationLoader(MarshallSolarActivityFutureEstimation.StrengthLevel strengthLevel, TimeScale utc) {
        super(utc);
        this.strengthLevel = strengthLevel;
        StringBuilder builder = new StringBuilder("^");
        builder.append("\\p{Blank}*(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})");
        builder.append("\\.\\p{Digit}+");
        builder.append("\\p{Blank}+(");
        for (Month month : Month.values()) {
            builder.append(month.getUpperCaseAbbreviation());
            builder.append('|');
        }
        builder.delete(builder.length() - 1, builder.length());
        builder.append(")");
        for (int i = 0; i < 6; ++i) {
            builder.append("\\p{Blank}+([-+]?[0-9]+\\.[0-9]+)");
        }
        builder.append("\\p{Blank}*$");
        this.dataPattern = Pattern.compile(builder.toString());
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int apGroup;
        int f107Group;
        switch (this.strengthLevel) {
            case STRONG: {
                f107Group = 3;
                apGroup = 6;
                break;
            }
            case AVERAGE: {
                f107Group = 4;
                apGroup = 7;
                break;
            }
            default: {
                f107Group = 5;
                apGroup = 8;
            }
        }
        boolean inData = false;
        DateComponents fileDate = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty()) {
                    Matcher matcher = this.dataPattern.matcher(line);
                    if (matcher.matches()) {
                        inData = true;
                        int year = Integer.parseInt(matcher.group(1));
                        Month month = Month.parseMonth(matcher.group(2));
                        AbsoluteDate date = new AbsoluteDate(year, month, 1, this.getUTC());
                        if (fileDate == null) {
                            fileDate = month.getNumber() > 6 ? new DateComponents(year + 1, month.getNumber() - 6, 1) : new DateComponents(year, month.getNumber() + 6, 1);
                        }
                        boolean addEntry = false;
                        Iterator iterator = this.data.tailSet(date).iterator();
                        if (iterator.hasNext()) {
                            LineParameters existingEntry = (LineParameters)iterator.next();
                            if (existingEntry.getDate().equals(date)) {
                                if (existingEntry.getFileDate().compareTo(fileDate) < 0) {
                                    iterator.remove();
                                    addEntry = true;
                                }
                            } else {
                                addEntry = true;
                            }
                        } else {
                            addEntry = true;
                        }
                        if (addEntry) {
                            this.data.add(new LineParameters(fileDate, date, Double.parseDouble(matcher.group(f107Group)), Double.parseDouble(matcher.group(apGroup))));
                        }
                    } else if (inData) {
                        throw new OrekitException((Localizable)OrekitMessages.NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE, name);
                    }
                }
                line = reader.readLine();
            }
        }
        if (this.data.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_MARSHALL_SOLAR_ACTIVITY_FUTURE_ESTIMATION_FILE, name);
        }
        this.setMinDate(this.data.first().getDate());
        this.setMaxDate(this.data.last().getDate());
    }

    @Override
    public SortedSet<LineParameters> getDataSet() {
        return this.data.stream().map(value -> (LineParameters)value).collect(Collectors.toCollection(TreeSet::new));
    }

    public static class LineParameters
    extends AbstractSolarActivityDataLoader.LineParameters {
        private static final long serialVersionUID = 6607862001953526475L;
        private final DateComponents fileDate;
        private final double f107;
        private final double ap;

        private LineParameters(DateComponents fileDate, AbsoluteDate date, double f107, double ap) {
            super(date);
            this.fileDate = fileDate;
            this.f107 = f107;
            this.ap = ap;
        }

        @Override
        public int compareTo(AbstractSolarActivityDataLoader.LineParameters lineParameters) {
            return this.getDate().compareTo(lineParameters.getDate());
        }

        @Override
        public boolean equals(Object otherInstance) {
            if (this == otherInstance) {
                return true;
            }
            if (otherInstance == null || this.getClass() != otherInstance.getClass()) {
                return false;
            }
            LineParameters msafeParams = (LineParameters)otherInstance;
            if (Double.compare(this.getF107(), msafeParams.getF107()) != 0) {
                return false;
            }
            if (Double.compare(this.getAp(), msafeParams.getAp()) != 0) {
                return false;
            }
            return this.getFileDate().equals(msafeParams.getFileDate());
        }

        @Override
        public int hashCode() {
            int result = this.getFileDate().hashCode();
            long temp = Double.doubleToLongBits(this.getF107());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.getAp());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public DateComponents getFileDate() {
            return this.fileDate;
        }

        public double getF107() {
            return this.f107;
        }

        public double getAp() {
            return this.ap;
        }
    }
}

