/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.models.earth.atmosphere.data.AbstractSolarActivityData;
import org.orekit.models.earth.atmosphere.data.MarshallSolarActivityFutureEstimationLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStampedDouble;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.OrekitConfiguration;
import org.orekit.utils.TimeStampedGenerator;

public class MarshallSolarActivityFutureEstimation
extends AbstractSolarActivityData<MarshallSolarActivityFutureEstimationLoader.LineParameters, MarshallSolarActivityFutureEstimationLoader> {
    public static final String DEFAULT_SUPPORTED_NAMES = "\\p{Alpha}\\p{Lower}\\p{Lower}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}(?:f|F)10(?:[-_]prd)?\\.(?:txt|TXT)";
    private static final long serialVersionUID = -5212198874900835369L;
    private final StrengthLevel strengthLevel;
    private final transient GenericTimeStampedCache<TimeStampedDouble> averageFluxCache;

    @DefaultDataContext
    public MarshallSolarActivityFutureEstimation(String supportedNames, StrengthLevel strengthLevel) {
        this(supportedNames, strengthLevel, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public MarshallSolarActivityFutureEstimation(String supportedNames, StrengthLevel strengthLevel, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this(supportedNames, strengthLevel, dataProvidersManager, utc, OrekitConfiguration.getCacheSlotsNumber(), 2678400.0, 0.0, 2332800.0);
    }

    public MarshallSolarActivityFutureEstimation(String supportedNames, StrengthLevel strengthLevel, DataProvidersManager dataProvidersManager, TimeScale utc, int maxSlots, double maxSpan, double maxInterval, double minimumStep) {
        super(supportedNames, new MarshallSolarActivityFutureEstimationLoader(strengthLevel, utc), dataProvidersManager, utc, maxSlots, maxSpan, maxInterval, minimumStep);
        this.strengthLevel = strengthLevel;
        this.averageFluxCache = new GenericTimeStampedCache<TimeStampedDouble>(2, OrekitConfiguration.getCacheSlotsNumber(), 86400.0, 0.0, new AverageFluxGenerator());
    }

    @DefaultDataContext
    public MarshallSolarActivityFutureEstimation(DataSource source, StrengthLevel strengthLevel) {
        this(source, strengthLevel, DataContext.getDefault().getTimeScales().getUTC());
    }

    public MarshallSolarActivityFutureEstimation(DataSource source, StrengthLevel strengthLevel, TimeScale utc) {
        this(source, strengthLevel, utc, OrekitConfiguration.getCacheSlotsNumber(), 2678400.0, 0.0, 2332800.0);
    }

    public MarshallSolarActivityFutureEstimation(DataSource source, StrengthLevel strengthLevel, TimeScale utc, int maxSlots, double maxSpan, double maxInterval, double minimumStep) {
        super(source, new MarshallSolarActivityFutureEstimationLoader(strengthLevel, utc), utc, maxSlots, maxSpan, maxInterval, minimumStep);
        this.strengthLevel = strengthLevel;
        this.averageFluxCache = new GenericTimeStampedCache<TimeStampedDouble>(2, OrekitConfiguration.getCacheSlotsNumber(), 86400.0, 0.0, new AverageFluxGenerator());
    }

    @Override
    public double getInstantFlux(AbsoluteDate date) {
        return this.getMeanFlux(date);
    }

    @Override
    public double getMeanFlux(AbsoluteDate date) {
        return this.getLinearInterpolation(date, MarshallSolarActivityFutureEstimationLoader.LineParameters::getF107);
    }

    @Override
    public double getThreeHourlyKP(AbsoluteDate date) {
        return this.get24HoursKp(date);
    }

    public DateComponents getFileDate(AbsoluteDate date) {
        double dtC;
        AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
        MarshallSolarActivityFutureEstimationLoader.LineParameters previousParam = (MarshallSolarActivityFutureEstimationLoader.LineParameters)localSolarActivity.getPreviousParam();
        MarshallSolarActivityFutureEstimationLoader.LineParameters currentParam = (MarshallSolarActivityFutureEstimationLoader.LineParameters)localSolarActivity.getNextParam();
        double dtP = date.durationFrom(previousParam.getDate());
        return dtP < (dtC = currentParam.getDate().durationFrom(date)) ? previousParam.getFileDate() : currentParam.getFileDate();
    }

    @Override
    public double get24HoursKp(AbsoluteDate date) {
        double ap = this.getDailyAp(date);
        return 1.89 * FastMath.asinh((double)(0.154 * ap));
    }

    @Override
    public double getDailyFlux(AbsoluteDate date) {
        return this.getMeanFlux(date.shiftedBy(-86400.0));
    }

    @Override
    public double getAverageFlux(AbsoluteDate date) {
        List neighbors = this.averageFluxCache.getNeighbors(date).collect(Collectors.toList());
        double[] x = new double[]{0.0, 1.0};
        double[] y = neighbors.stream().map(TimeStampedDouble::getValue).mapToDouble(Double::doubleValue).toArray();
        LinearInterpolator interpolator = new LinearInterpolator();
        PolynomialSplineFunction interpolatingFunction = interpolator.interpolate(x, y);
        AbsoluteDate previousDate = ((TimeStampedDouble)neighbors.get(0)).getDate();
        AbsoluteDate nextDate = ((TimeStampedDouble)neighbors.get(1)).getDate();
        return interpolatingFunction.value(date.durationFrom(previousDate) / nextDate.durationFrom(previousDate));
    }

    @Override
    public double[] getAp(AbsoluteDate date) {
        double ap = this.getDailyAp(date);
        return new double[]{ap, ap, ap, ap, ap, ap, ap};
    }

    private double getDailyAp(AbsoluteDate date) {
        return this.getLinearInterpolation(date, MarshallSolarActivityFutureEstimationLoader.LineParameters::getAp);
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DataTransferObject(this.getSupportedNames(), this.strengthLevel);
    }

    public StrengthLevel getStrengthLevel() {
        return this.strengthLevel;
    }

    @DefaultDataContext
    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = -5212198874900835369L;
        private final String supportedNames;
        private final StrengthLevel strengthLevel;

        DataTransferObject(String supportedNames, StrengthLevel strengthLevel) {
            this.supportedNames = supportedNames;
            this.strengthLevel = strengthLevel;
        }

        private Object readResolve() {
            try {
                return new MarshallSolarActivityFutureEstimation(this.supportedNames, this.strengthLevel);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private class AverageFluxGenerator
    implements TimeStampedGenerator<TimeStampedDouble> {
        private AverageFluxGenerator() {
        }

        @Override
        public List<TimeStampedDouble> generate(AbsoluteDate existingDate, AbsoluteDate date) {
            if (existingDate == null) {
                return this.generateDataFromEarliestToLatestDates(this.getCurrentDay(date), this.getNextDay(date));
            }
            if (date.isBefore(existingDate)) {
                return this.generateDataFromEarliestToLatestDates(date, existingDate);
            }
            return this.generateDataFromEarliestToLatestDates(existingDate, date);
        }

        private List<TimeStampedDouble> generateDataFromEarliestToLatestDates(AbsoluteDate earliest, AbsoluteDate latest) {
            ArrayList<TimeStampedDouble> generated = new ArrayList<TimeStampedDouble>();
            AbsoluteDate latestNeighbourDate = this.getCurrentDay(earliest);
            while (latestNeighbourDate.isBeforeOrEqualTo(latest)) {
                generated.add(this.computeAverageFlux(latestNeighbourDate));
                latestNeighbourDate = this.getNextDay(latestNeighbourDate);
            }
            return generated;
        }

        private AbsoluteDate getCurrentDay(AbsoluteDate date) {
            TimeScale utc = MarshallSolarActivityFutureEstimation.this.getUTC();
            DateComponents dateComponents = date.getComponents(utc).getDate();
            return new AbsoluteDate(new DateTimeComponents(dateComponents, TimeComponents.H00), utc);
        }

        private AbsoluteDate getNextDay(AbsoluteDate date) {
            TimeScale utc = MarshallSolarActivityFutureEstimation.this.getUTC();
            DateComponents dateComponents = date.getComponents(utc).getDate();
            DateComponents shiftedComponents = new DateComponents(dateComponents, 1);
            return new AbsoluteDate(new DateTimeComponents(shiftedComponents, TimeComponents.H00), utc);
        }

        private TimeStampedDouble computeAverageFlux(AbsoluteDate date) {
            TimeStampedGenerator generator = MarshallSolarActivityFutureEstimation.this.getCache().getGenerator();
            AbsoluteDate initialDate = date.shiftedBy(-3456000.0);
            AbsoluteDate finalDate = date.shiftedBy(3456000.0);
            List monthlyData = generator.generate(initialDate, finalDate);
            LinearInterpolator interpolator = new LinearInterpolator();
            double[] x = monthlyData.stream().map(param -> param.getDate().durationFrom(initialDate)).mapToDouble(Double::doubleValue).toArray();
            double[] y = monthlyData.stream().map(MarshallSolarActivityFutureEstimationLoader.LineParameters::getF107).mapToDouble(Double::doubleValue).toArray();
            PolynomialSplineFunction interpolatingFunction = interpolator.interpolate(x, y);
            double average = 0.0;
            for (int i = -40; i < 41; ++i) {
                average += interpolatingFunction.value(date.shiftedBy((double)i * 86400.0).durationFrom(initialDate));
            }
            return new TimeStampedDouble(average / 81.0, date);
        }
    }

    public static enum StrengthLevel {
        STRONG,
        AVERAGE,
        WEAK;

    }
}

