/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.JB2008InputParameters;
import org.orekit.models.earth.atmosphere.data.DtcDataLoader;
import org.orekit.models.earth.atmosphere.data.SOLFSMYDataLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.ImmutableTimeStampedCache;

public class JB2008SpaceEnvironmentData
implements JB2008InputParameters {
    public static final String DEFAULT_SUPPORTED_NAMES_SOLFSMY = "(SOLFSMY)(.*)((\\.txt)|(\\.TXT))";
    public static final String DEFAULT_SUPPORTED_NAMES_DTC = "DTCFILE.TXT";
    private static final long serialVersionUID = 7735042547323407578L;
    private static final int N_NEIGHBORS = 2;
    private final transient ImmutableTimeStampedCache<SOLFSMYDataLoader.LineParameters> dataSOL;
    private final transient ImmutableTimeStampedCache<DtcDataLoader.LineParameters> dataDTC;
    private final AbsoluteDate firstDate;
    private final AbsoluteDate lastDate;
    private SOLFSMYDataLoader.LineParameters previousParamSOL;
    private SOLFSMYDataLoader.LineParameters nextParamSOL;
    private DtcDataLoader.LineParameters previousParamDTC;
    private DtcDataLoader.LineParameters nextParamDTC;

    @DefaultDataContext
    public JB2008SpaceEnvironmentData(String supportedNamesSOL, String supportedNamesDTC) {
        this(supportedNamesSOL, supportedNamesDTC, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public JB2008SpaceEnvironmentData(String supportedNamesSOL, String supportedNamesDTC, DataProvidersManager dataProvidersManager, TimeScale utc) {
        SOLFSMYDataLoader loaderSOL = new SOLFSMYDataLoader(utc);
        dataProvidersManager.feed(supportedNamesSOL, loaderSOL);
        this.dataSOL = new ImmutableTimeStampedCache<SOLFSMYDataLoader.LineParameters>(2, loaderSOL.getDataSet());
        DtcDataLoader loaderDTC = new DtcDataLoader(utc);
        dataProvidersManager.feed(supportedNamesDTC, loaderDTC);
        this.dataDTC = new ImmutableTimeStampedCache<DtcDataLoader.LineParameters>(2, loaderDTC.getDataSet());
        this.firstDate = loaderSOL.getMinDate();
        this.lastDate = loaderSOL.getMaxDate();
    }

    @DefaultDataContext
    public JB2008SpaceEnvironmentData(DataSource sourceSolfsmy, DataSource sourceDtc) {
        this(sourceSolfsmy, sourceDtc, DataContext.getDefault().getTimeScales().getUTC());
    }

    public JB2008SpaceEnvironmentData(DataSource sourceSolfsmy, DataSource sourceDtc, TimeScale utc) {
        try {
            SOLFSMYDataLoader loaderSOL = new SOLFSMYDataLoader(utc);
            try (InputStream is = sourceSolfsmy.getOpener().openStreamOnce();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                loaderSOL.loadData(bis, sourceSolfsmy.getName());
            }
            DtcDataLoader loaderDTC = new DtcDataLoader(utc);
            try (InputStream is = sourceDtc.getOpener().openStreamOnce();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                loaderDTC.loadData(bis, sourceDtc.getName());
            }
            this.dataSOL = new ImmutableTimeStampedCache<SOLFSMYDataLoader.LineParameters>(2, loaderSOL.getDataSet());
            this.dataDTC = new ImmutableTimeStampedCache<DtcDataLoader.LineParameters>(2, loaderDTC.getDataSet());
            this.firstDate = loaderSOL.getMinDate();
            this.lastDate = loaderSOL.getMaxDate();
        }
        catch (IOException | ParseException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    private void bracketDateSOL(AbsoluteDate date) {
        AbsoluteDate firstDateUsefulSOL = this.firstDate.shiftedBy(-432000.0);
        if (date.durationFrom(firstDateUsefulSOL) < 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE, date, firstDateUsefulSOL, this.lastDate, firstDateUsefulSOL.durationFrom(date));
        }
        if (date.durationFrom(this.lastDate) > 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER, date, firstDateUsefulSOL, this.lastDate, date.durationFrom(this.lastDate));
        }
        if (this.previousParamSOL != null && date.durationFrom(this.previousParamSOL.getDate()) > 0.0 && date.durationFrom(this.nextParamSOL.getDate()) <= 0.0) {
            return;
        }
        List neigbors = this.dataSOL.getNeighbors(date).collect(Collectors.toList());
        this.previousParamSOL = (SOLFSMYDataLoader.LineParameters)neigbors.get(0);
        this.nextParamSOL = (SOLFSMYDataLoader.LineParameters)neigbors.get(1);
    }

    private void bracketDateDTC(AbsoluteDate date) {
        AbsoluteDate firstDateUsefulDTC = this.firstDate;
        if (date.durationFrom(firstDateUsefulDTC) < 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE, date, firstDateUsefulDTC, this.lastDate, firstDateUsefulDTC.durationFrom(date));
        }
        if (date.durationFrom(this.lastDate) > 0.0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER, date, firstDateUsefulDTC, this.lastDate, date.durationFrom(this.lastDate));
        }
        if (this.previousParamDTC != null && date.durationFrom(this.previousParamDTC.getDate()) > 0.0 && date.durationFrom(this.nextParamDTC.getDate()) <= 0.0) {
            return;
        }
        List neigbors = this.dataDTC.getNeighbors(date).collect(Collectors.toList());
        this.previousParamDTC = (DtcDataLoader.LineParameters)neigbors.get(0);
        this.nextParamDTC = (DtcDataLoader.LineParameters)neigbors.get(1);
    }

    private double getLinearInterpolationSOL(AbsoluteDate date, double previousValue, double nextValue) {
        return this.linearInterpolation(date, previousValue, this.previousParamSOL.getDate(), nextValue, this.nextParamSOL.getDate());
    }

    private double getLinearInterpolationDTC(AbsoluteDate date, double previousValue, double nextValue) {
        return this.linearInterpolation(date, previousValue, this.previousParamDTC.getDate(), nextValue, this.nextParamDTC.getDate());
    }

    private double linearInterpolation(AbsoluteDate date, double previousValue, AbsoluteDate previousDate, double nextValue, AbsoluteDate nextDate) {
        double dt = nextDate.durationFrom(previousDate);
        double previousWeight = nextDate.durationFrom(date) / dt;
        double nextWeight = date.durationFrom(previousDate) / dt;
        return previousValue * previousWeight + nextValue * nextWeight;
    }

    @Override
    public double getF10(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-86400.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getF10(), this.nextParamSOL.getF10());
    }

    @Override
    public double getF10B(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-86400.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getF10B(), this.nextParamSOL.getF10B());
    }

    @Override
    public double getS10(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-86400.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getS10(), this.nextParamSOL.getS10());
    }

    @Override
    public double getS10B(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-86400.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getS10B(), this.nextParamSOL.getS10B());
    }

    @Override
    public double getXM10(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-172800.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getXM10(), this.nextParamSOL.getXM10());
    }

    @Override
    public double getXM10B(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-172800.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getXM10B(), this.nextParamSOL.getXM10B());
    }

    @Override
    public double getY10(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-432000.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getY10(), this.nextParamSOL.getY10());
    }

    @Override
    public double getY10B(AbsoluteDate date) {
        AbsoluteDate workDate = date.shiftedBy(-432000.0);
        this.bracketDateSOL(workDate);
        return this.getLinearInterpolationSOL(workDate, this.previousParamSOL.getY10B(), this.nextParamSOL.getY10B());
    }

    @Override
    public double getDSTDTC(AbsoluteDate date) {
        this.bracketDateDTC(date);
        return this.getLinearInterpolationDTC(date, this.previousParamDTC.getDSTDTC(), this.nextParamDTC.getDSTDTC());
    }
}

