/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.data.AbstractSolarActivityDataLoader;
import org.orekit.models.earth.atmosphere.data.CommonLineReader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public class CssiSpaceWeatherDataLoader
extends AbstractSolarActivityDataLoader<LineParameters> {
    private AbsoluteDate lastObservedDate = null;
    private AbsoluteDate lastDailyPredictedDate = null;
    private final SortedSet<LineParameters> set = new TreeSet<TimeStamped>(new ChronologicalComparator());

    public CssiSpaceWeatherDataLoader(TimeScale utc) {
        super(utc);
    }

    private static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        int lineNumber = 0;
        String line = null;
        HashSet<AbsoluteDate> parsedEpochs = new HashSet<AbsoluteDate>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            CommonLineReader reader = new CommonLineReader(br);
            line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                if (!(line = line.trim()).isEmpty()) {
                    int day;
                    int month;
                    int year;
                    AbsoluteDate date;
                    if (line.equals("BEGIN DAILY_PREDICTED")) {
                        this.lastObservedDate = this.set.last().getDate();
                    }
                    if (line.equals("BEGIN MONTHLY_FIT")) {
                        this.lastDailyPredictedDate = this.set.last().getDate();
                    }
                    if (line.length() == 130 && CssiSpaceWeatherDataLoader.isNumeric(line.substring(0, 4)) && parsedEpochs.add(date = new AbsoluteDate(year = Integer.parseInt(line.substring(0, 4)), month = Integer.parseInt(line.substring(5, 7)), day = Integer.parseInt(line.substring(8, 10)), this.getUTC()))) {
                        double[] threeHourlyKp = new double[8];
                        for (int i = 0; i < 8; ++i) {
                            threeHourlyKp[i] = 0.1 * Double.parseDouble(line.substring(19 + 3 * i, 21 + 3 * i));
                        }
                        double kpSum = 0.1 * Double.parseDouble(line.substring(43, 46));
                        double[] threeHourlyAp = new double[8];
                        for (int i = 0; i < 8; ++i) {
                            threeHourlyAp[i] = Double.parseDouble(line.substring(47 + 4 * i, 50 + 4 * i));
                        }
                        double apAvg = Double.parseDouble(line.substring(79, 82));
                        double f107Adj = Double.parseDouble(line.substring(93, 98));
                        int fluxQualifier = Integer.parseInt(line.substring(99, 100));
                        double ctr81Adj = Double.parseDouble(line.substring(101, 106));
                        double lst81Adj = Double.parseDouble(line.substring(107, 112));
                        double f107Obs = Double.parseDouble(line.substring(113, 118));
                        double ctr81Obs = Double.parseDouble(line.substring(119, 124));
                        double lst81Obs = Double.parseDouble(line.substring(125, 130));
                        this.set.add(new LineParameters(date, threeHourlyKp, kpSum, threeHourlyAp, apAvg, f107Adj, fluxQualifier, ctr81Adj, lst81Adj, f107Obs, ctr81Obs, lst81Obs));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException(nfe, OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
        try {
            this.setMinDate(this.set.first().getDate());
            this.setMaxDate(this.set.last().getDate());
        }
        catch (NoSuchElementException nse) {
            throw new OrekitException(nse, OrekitMessages.NO_DATA_IN_FILE, name);
        }
    }

    @Override
    public SortedSet<LineParameters> getDataSet() {
        return this.set;
    }

    public AbsoluteDate getLastDailyPredictedDate() {
        return this.lastDailyPredictedDate;
    }

    public AbsoluteDate getLastObservedDate() {
        return this.lastObservedDate;
    }

    public static class LineParameters
    extends AbstractSolarActivityDataLoader.LineParameters {
        private static final long serialVersionUID = 8151260459653484163L;
        private final double[] threeHourlyKp;
        private final double kpSum;
        private final double[] threeHourlyAp;
        private final double apAvg;
        private final double f107Adj;
        private final int fluxQualifier;
        private final double ctr81Adj;
        private final double lst81Adj;
        private final double f107Obs;
        private final double ctr81Obs;
        private final double lst81Obs;

        public LineParameters(AbsoluteDate date, double[] threeHourlyKp, double kpSum, double[] threeHourlyAp, double apAvg, double f107Adj, int fluxQualifier, double ctr81Adj, double lst81Adj, double f107Obs, double ctr81Obs, double lst81Obs) {
            super(date);
            this.threeHourlyKp = (double[])threeHourlyKp.clone();
            this.kpSum = kpSum;
            this.threeHourlyAp = (double[])threeHourlyAp.clone();
            this.apAvg = apAvg;
            this.f107Adj = f107Adj;
            this.fluxQualifier = fluxQualifier;
            this.ctr81Adj = ctr81Adj;
            this.lst81Adj = lst81Adj;
            this.f107Obs = f107Obs;
            this.ctr81Obs = ctr81Obs;
            this.lst81Obs = lst81Obs;
        }

        @Override
        public int compareTo(AbstractSolarActivityDataLoader.LineParameters lineParameters) {
            return this.getDate().compareTo(lineParameters.getDate());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineParameters that = (LineParameters)o;
            if (Double.compare(this.getKpSum(), that.getKpSum()) != 0) {
                return false;
            }
            if (Double.compare(this.getApAvg(), that.getApAvg()) != 0) {
                return false;
            }
            if (Double.compare(this.getF107Adj(), that.getF107Adj()) != 0) {
                return false;
            }
            if (this.getFluxQualifier() != that.getFluxQualifier()) {
                return false;
            }
            if (Double.compare(this.getCtr81Adj(), that.getCtr81Adj()) != 0) {
                return false;
            }
            if (Double.compare(this.getLst81Adj(), that.getLst81Adj()) != 0) {
                return false;
            }
            if (Double.compare(this.getF107Obs(), that.getF107Obs()) != 0) {
                return false;
            }
            if (Double.compare(this.getCtr81Obs(), that.getCtr81Obs()) != 0) {
                return false;
            }
            if (Double.compare(this.getLst81Obs(), that.getLst81Obs()) != 0) {
                return false;
            }
            if (!Arrays.equals(this.getThreeHourlyKp(), that.getThreeHourlyKp())) {
                return false;
            }
            return Arrays.equals(this.getThreeHourlyAp(), that.getThreeHourlyAp());
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.getThreeHourlyKp());
            long temp = Double.doubleToLongBits(this.getKpSum());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + Arrays.hashCode(this.getThreeHourlyAp());
            temp = Double.doubleToLongBits(this.getApAvg());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.getF107Adj());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + this.getFluxQualifier();
            temp = Double.doubleToLongBits(this.getCtr81Adj());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.getLst81Adj());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.getF107Obs());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.getCtr81Obs());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.getLst81Obs());
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public double getThreeHourlyKp(int i) {
            return this.threeHourlyKp[i];
        }

        public double getThreeHourlyAp(int i) {
            return this.threeHourlyAp[i];
        }

        public double[] getThreeHourlyKp() {
            return (double[])this.threeHourlyKp.clone();
        }

        public double getKpSum() {
            return this.kpSum;
        }

        public double[] getThreeHourlyAp() {
            return (double[])this.threeHourlyAp.clone();
        }

        public double getApAvg() {
            return this.apAvg;
        }

        public double getLst81Obs() {
            return this.lst81Obs;
        }

        public double getCtr81Obs() {
            return this.ctr81Obs;
        }

        public double getF107Obs() {
            return this.f107Obs;
        }

        public double getLst81Adj() {
            return this.lst81Adj;
        }

        public double getCtr81Adj() {
            return this.ctr81Adj;
        }

        public int getFluxQualifier() {
            return this.fluxQualifier;
        }

        public double getF107Adj() {
            return this.f107Adj;
        }
    }
}

