/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.models.earth.atmosphere.data.AbstractSolarActivityData;
import org.orekit.models.earth.atmosphere.data.CssiSpaceWeatherDataLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.OrekitConfiguration;

public class CssiSpaceWeatherData
extends AbstractSolarActivityData<CssiSpaceWeatherDataLoader.LineParameters, CssiSpaceWeatherDataLoader> {
    public static final String DEFAULT_SUPPORTED_NAMES = "^S(?:pace)?W(?:eather)?-(?:All)?.*\\.txt$";
    private static final long serialVersionUID = 4249411710645968978L;
    private final AbsoluteDate lastObservedDate;
    private final AbsoluteDate lastDailyPredictedDate;

    @DefaultDataContext
    public CssiSpaceWeatherData(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), (TimeScale)DataContext.getDefault().getTimeScales().getUTC());
    }

    public CssiSpaceWeatherData(String supportedNames, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this(supportedNames, new CssiSpaceWeatherDataLoader(utc), dataProvidersManager, utc);
    }

    public CssiSpaceWeatherData(String supportedNames, CssiSpaceWeatherDataLoader loader, DataProvidersManager dataProvidersManager, TimeScale utc) {
        this(supportedNames, loader, dataProvidersManager, utc, OrekitConfiguration.getCacheSlotsNumber(), 86400.0, 0.0);
    }

    public CssiSpaceWeatherData(String supportedNames, CssiSpaceWeatherDataLoader loader, DataProvidersManager dataProvidersManager, TimeScale utc, int maxSlots, double maxSpan, double maxInterval) {
        super(supportedNames, loader, dataProvidersManager, utc, maxSlots, maxSpan, maxInterval, 86400.0);
        this.lastObservedDate = loader.getLastObservedDate();
        this.lastDailyPredictedDate = loader.getLastDailyPredictedDate();
    }

    @DefaultDataContext
    public CssiSpaceWeatherData(DataSource source) {
        this(source, DataContext.getDefault().getTimeScales().getUTC());
    }

    public CssiSpaceWeatherData(DataSource source, TimeScale utc) {
        this(source, new CssiSpaceWeatherDataLoader(utc), utc);
    }

    public CssiSpaceWeatherData(DataSource source, CssiSpaceWeatherDataLoader loader, TimeScale utc) {
        this(source, loader, utc, OrekitConfiguration.getCacheSlotsNumber(), 86400.0, 0.0);
    }

    public CssiSpaceWeatherData(DataSource source, CssiSpaceWeatherDataLoader loader, TimeScale utc, int maxSlots, double maxSpan, double maxInterval) {
        super(source, loader, utc, maxSlots, maxSpan, maxInterval, 86400.0);
        this.lastObservedDate = loader.getLastObservedDate();
        this.lastDailyPredictedDate = loader.getLastDailyPredictedDate();
    }

    @Override
    public double getInstantFlux(AbsoluteDate date) {
        return this.getLinearInterpolation(date, CssiSpaceWeatherDataLoader.LineParameters::getF107Obs);
    }

    @Override
    public double getMeanFlux(AbsoluteDate date) {
        return this.getAverageFlux(date);
    }

    @Override
    public double getThreeHourlyKP(AbsoluteDate date) {
        if (date.compareTo(this.lastObservedDate) <= 0) {
            AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
            CssiSpaceWeatherDataLoader.LineParameters previousParam = (CssiSpaceWeatherDataLoader.LineParameters)localSolarActivity.getPreviousParam();
            double hourOfDay = date.offsetFrom(previousParam.getDate(), this.getUTC()) / 3600.0;
            int i_kp = (int)(hourOfDay / 3.0);
            if (i_kp >= 8) {
                i_kp = 7;
            }
            return previousParam.getThreeHourlyKp(i_kp);
        }
        return this.get24HoursKp(date);
    }

    @Override
    public double get24HoursKp(AbsoluteDate date) {
        AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            return ((CssiSpaceWeatherDataLoader.LineParameters)localSolarActivity.getPreviousParam()).getKpSum() / 8.0;
        }
        return this.getLinearInterpolation(localSolarActivity, (L lineParam) -> lineParam.getKpSum() / 8.0);
    }

    @Override
    public double getDailyFlux(AbsoluteDate date) {
        return this.getDailyFluxOnDay(date.shiftedBy(-86400.0));
    }

    @Override
    public double getAverageFlux(AbsoluteDate date) {
        AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            return ((CssiSpaceWeatherDataLoader.LineParameters)localSolarActivity.getPreviousParam()).getCtr81Obs();
        }
        return this.getLinearInterpolation(localSolarActivity, CssiSpaceWeatherDataLoader.LineParameters::getCtr81Obs);
    }

    @Override
    public double[] getAp(AbsoluteDate date) {
        double[] apArray = new double[]{this.getDailyAp(date), this.getThreeHourlyAp(date), this.getThreeHourlyAp(date.shiftedBy(-10800.0)), this.getThreeHourlyAp(date.shiftedBy(-21600.0)), this.getThreeHourlyAp(date.shiftedBy(-32400.0)), this.get24HoursAverageAp(date.shiftedBy(-43200.0)), this.get24HoursAverageAp(date.shiftedBy(-129600.0))};
        return apArray;
    }

    private double getDailyFluxOnDay(AbsoluteDate date) {
        AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            return ((CssiSpaceWeatherDataLoader.LineParameters)localSolarActivity.getPreviousParam()).getF107Obs();
        }
        return this.getLinearInterpolation(localSolarActivity, CssiSpaceWeatherDataLoader.LineParameters::getF107Obs);
    }

    private double getThreeHourlyAp(AbsoluteDate date) {
        if (date.compareTo(this.lastObservedDate.shiftedBy(86400.0)) < 0) {
            AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
            CssiSpaceWeatherDataLoader.LineParameters previousParam = (CssiSpaceWeatherDataLoader.LineParameters)localSolarActivity.getPreviousParam();
            double hourOfDay = date.offsetFrom(previousParam.getDate(), this.getUTC()) / 3600.0;
            int i_ap = (int)(hourOfDay / 3.0);
            if (i_ap >= 8) {
                i_ap = 7;
            }
            return previousParam.getThreeHourlyAp(i_ap);
        }
        return this.getDailyAp(date);
    }

    private double get24HoursAverageAp(AbsoluteDate date) {
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            double apSum = 0.0;
            for (int i = 0; i < 8; ++i) {
                apSum += this.getThreeHourlyAp(date.shiftedBy(-10800.0 * (double)i));
            }
            return apSum / 8.0;
        }
        return this.getDailyAp(date);
    }

    private double getDailyAp(AbsoluteDate date) {
        AbstractSolarActivityData.LocalSolarActivity localSolarActivity = new AbstractSolarActivityData.LocalSolarActivity(this, date);
        if (date.compareTo(this.lastDailyPredictedDate) <= 0) {
            return ((CssiSpaceWeatherDataLoader.LineParameters)localSolarActivity.getPreviousParam()).getApAvg();
        }
        return this.getLinearInterpolation(localSolarActivity, CssiSpaceWeatherDataLoader.LineParameters::getApAvg);
    }
}

