/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.Serializable;
import java.util.SortedSet;
import org.orekit.data.DataLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;

public abstract class AbstractSolarActivityDataLoader<L extends LineParameters>
implements DataLoader {
    private final TimeScale utc;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;

    protected AbstractSolarActivityDataLoader(TimeScale utc) {
        this.utc = utc;
    }

    @Override
    public boolean stillAcceptsData() {
        return true;
    }

    public abstract SortedSet<L> getDataSet();

    public TimeScale getUTC() {
        return this.utc;
    }

    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    public void setMinDate(AbsoluteDate date) {
        this.firstDate = date;
    }

    public void setMaxDate(AbsoluteDate date) {
        this.lastDate = date;
    }

    public static abstract class LineParameters
    implements TimeStamped,
    Comparable<LineParameters>,
    Serializable {
        private static final long serialVersionUID = 6607862001953526475L;
        private final AbsoluteDate date;

        protected LineParameters(AbsoluteDate date) {
            this.date = date;
        }

        @Override
        public abstract int compareTo(LineParameters var1);

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }
    }
}

