/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere.data;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.data.DataSource;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.atmosphere.DTM2000InputParameters;
import org.orekit.models.earth.atmosphere.NRLMSISE00InputParameters;
import org.orekit.models.earth.atmosphere.data.AbstractSolarActivityDataLoader;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeStamped;
import org.orekit.utils.GenericTimeStampedCache;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.TimeStampedGenerator;

public abstract class AbstractSolarActivityData<L extends AbstractSolarActivityDataLoader.LineParameters, D extends AbstractSolarActivityDataLoader<L>>
implements DTM2000InputParameters,
NRLMSISE00InputParameters {
    protected static final int N_NEIGHBORS = 2;
    private static final long serialVersionUID = 8804818166227680449L;
    private final transient GenericTimeStampedCache<L> cache;
    private final String supportedNames;
    private final TimeScale utc;
    private final AbsoluteDate firstDate;
    private final AbsoluteDate lastDate;

    protected AbstractSolarActivityData(String supportedNames, D loader, DataProvidersManager dataProvidersManager, TimeScale utc, int maxSlots, double maxSpan, double maxInterval, double minimumStep) {
        dataProvidersManager.feed(supportedNames, (DataLoader)loader);
        this.cache = new GenericTimeStampedCache(2, maxSlots, maxSpan, maxInterval, new SolarActivityGenerator(((AbstractSolarActivityDataLoader)loader).getDataSet()), minimumStep);
        this.supportedNames = supportedNames;
        this.utc = utc;
        this.firstDate = ((AbstractSolarActivityDataLoader)loader).getMinDate();
        this.lastDate = ((AbstractSolarActivityDataLoader)loader).getMaxDate();
    }

    public AbstractSolarActivityData(DataSource source, D loader, TimeScale utc, int maxSlots, double maxSpan, double maxInterval, double minimumStep) {
        try {
            try (InputStream is = source.getOpener().openStreamOnce();
                 BufferedInputStream bis = new BufferedInputStream(is);){
                loader.loadData(bis, source.getName());
            }
            this.cache = new GenericTimeStampedCache(2, maxSlots, maxSpan, maxInterval, new SolarActivityGenerator(((AbstractSolarActivityDataLoader)loader).getDataSet()), minimumStep);
            this.supportedNames = source.getName();
            this.utc = utc;
            this.firstDate = ((AbstractSolarActivityDataLoader)loader).getMinDate();
            this.lastDate = ((AbstractSolarActivityDataLoader)loader).getMaxDate();
        }
        catch (IOException | ParseException ioe) {
            throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
        }
    }

    protected double getLinearInterpolation(AbsoluteDate date, Function<L, Double> solarActivityToDoubleMapper) {
        LocalSolarActivity localSolarActivity = new LocalSolarActivity(date);
        return this.getLinearInterpolation(localSolarActivity, solarActivityToDoubleMapper);
    }

    protected double getLinearInterpolation(LocalSolarActivity localSolarActivity, Function<L, Double> solarActivityToDoubleMapper) {
        Object previousParameters = localSolarActivity.getPreviousParam();
        double previousValue = solarActivityToDoubleMapper.apply(previousParameters);
        Object nextParameters = localSolarActivity.getNextParam();
        double nextValue = solarActivityToDoubleMapper.apply(nextParameters);
        AbsoluteDate previousDate = ((AbstractSolarActivityDataLoader.LineParameters)localSolarActivity.getPreviousParam()).getDate();
        AbsoluteDate currentDate = ((AbstractSolarActivityDataLoader.LineParameters)localSolarActivity.getNextParam()).getDate();
        double dt = currentDate.durationFrom(previousDate);
        AbsoluteDate date = localSolarActivity.getDate();
        double previousWeight = currentDate.durationFrom(date) / dt;
        double nextWeight = date.durationFrom(previousDate) / dt;
        return previousValue * previousWeight + nextValue * nextWeight;
    }

    public GenericTimeStampedCache<L> getCache() {
        return this.cache;
    }

    public String getSupportedNames() {
        return this.supportedNames;
    }

    public TimeScale getUTC() {
        return this.utc;
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.firstDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.lastDate;
    }

    protected class SolarActivityGenerator
    implements TimeStampedGenerator<L> {
        private static final double STEP = 1.0;
        private final ImmutableTimeStampedCache<L> data;

        protected SolarActivityGenerator(Collection<L> dataSet) {
            this.data = new ImmutableTimeStampedCache(2, dataSet);
        }

        @Override
        public List<L> generate(AbsoluteDate existingDate, AbsoluteDate date) {
            if (existingDate == null) {
                return this.data.getNeighbors(date).collect(Collectors.toList());
            }
            if (date.isBefore(existingDate)) {
                return this.generateDataFromEarliestToLatestDates(date, existingDate);
            }
            return this.generateDataFromEarliestToLatestDates(existingDate, date);
        }

        public List<L> generateDataFromEarliestToLatestDates(AbsoluteDate earliest, AbsoluteDate latest) {
            List neighbours = this.data.getNeighbors(earliest.shiftedBy(1.0)).collect(Collectors.toList());
            AbsoluteDate latestNeighbourDate = ((AbstractSolarActivityDataLoader.LineParameters)neighbours.get(1)).getDate();
            ArrayList params = new ArrayList(neighbours);
            while (latestNeighbourDate.isBefore(latest)) {
                neighbours = this.data.getNeighbors(latestNeighbourDate.shiftedBy(1.0)).collect(Collectors.toList());
                params.add((AbstractSolarActivityDataLoader.LineParameters)neighbours.get(1));
                latestNeighbourDate = ((AbstractSolarActivityDataLoader.LineParameters)neighbours.get(1)).getDate();
            }
            return params;
        }
    }

    protected class LocalSolarActivity
    implements TimeStamped {
        private final AbsoluteDate currentDate;
        private final L previousParam;
        private final L nextParam;

        public LocalSolarActivity(AbsoluteDate date) {
            if (date.durationFrom(AbstractSolarActivityData.this.firstDate) < 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE, date, AbstractSolarActivityData.this.firstDate, AbstractSolarActivityData.this.lastDate, AbstractSolarActivityData.this.firstDate.durationFrom(date));
            }
            if (date.durationFrom(AbstractSolarActivityData.this.lastDate) > 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER, date, AbstractSolarActivityData.this.firstDate, AbstractSolarActivityData.this.lastDate, date.durationFrom(AbstractSolarActivityData.this.lastDate));
            }
            List neighbours = AbstractSolarActivityData.this.cache.getNeighbors(date).collect(Collectors.toList());
            this.currentDate = date;
            this.previousParam = (AbstractSolarActivityDataLoader.LineParameters)neighbours.get(0);
            this.nextParam = (AbstractSolarActivityDataLoader.LineParameters)neighbours.get(1);
        }

        @Override
        public AbsoluteDate getDate() {
            return this.currentDate;
        }

        public L getPreviousParam() {
            return this.previousParam;
        }

        public L getNextParam() {
            return this.nextParam;
        }
    }
}

