/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;

public class HarrisPriester
implements Atmosphere {
    private static final long serialVersionUID = 2772347498196369601L;
    private static final int N_DEFAULT = 4;
    private static final double MIN_COS = 1.0E-12;
    private static final double LAG = FastMath.toRadians((double)30.0);
    private static final SinCos SCLAG = FastMath.sinCos((double)LAG);
    private static final double[][] ALT_RHO = new double[][]{{100000.0, 4.974E-7, 4.974E-7}, {120000.0, 2.49E-8, 2.49E-8}, {130000.0, 8.377E-9, 8.71E-9}, {140000.0, 3.899E-9, 4.059E-9}, {150000.0, 2.122E-9, 2.215E-9}, {160000.0, 1.263E-9, 1.344E-9}, {170000.0, 8.008E-10, 8.758E-10}, {180000.0, 5.283E-10, 6.01E-10}, {190000.0, 3.617E-10, 4.297E-10}, {200000.0, 2.557E-10, 3.162E-10}, {210000.0, 1.839E-10, 2.396E-10}, {220000.0, 1.341E-10, 1.853E-10}, {230000.0, 9.949E-11, 1.455E-10}, {240000.0, 7.488E-11, 1.157E-10}, {250000.0, 5.709E-11, 9.308E-11}, {260000.0, 4.403E-11, 7.555E-11}, {270000.0, 3.43E-11, 6.182E-11}, {280000.0, 2.697E-11, 5.095E-11}, {290000.0, 2.139E-11, 4.226E-11}, {300000.0, 1.708E-11, 3.526E-11}, {320000.0, 1.099E-11, 2.511E-11}, {340000.0, 7.214E-12, 1.819E-11}, {360000.0, 4.824E-12, 1.337E-11}, {380000.0, 3.274E-12, 9.955E-12}, {400000.0, 2.249E-12, 7.492E-12}, {420000.0, 1.558E-12, 5.684E-12}, {440000.0, 1.091E-12, 4.355E-12}, {460000.0, 7.701E-13, 3.362E-12}, {480000.0, 5.474E-13, 2.612E-12}, {500000.0, 3.916E-13, 2.042E-12}, {520000.0, 2.819E-13, 1.605E-12}, {540000.0, 2.042E-13, 1.267E-12}, {560000.0, 1.488E-13, 1.005E-12}, {580000.0, 1.092E-13, 7.997E-13}, {600000.0, 8.07E-14, 6.39E-13}, {620000.0, 6.012E-14, 5.123E-13}, {640000.0, 4.519E-14, 4.121E-13}, {660000.0, 3.43E-14, 3.325E-13}, {680000.0, 2.632E-14, 2.691E-13}, {700000.0, 2.043E-14, 2.185E-13}, {720000.0, 1.607E-14, 1.779E-13}, {740000.0, 1.281E-14, 1.452E-13}, {760000.0, 1.036E-14, 1.19E-13}, {780000.0, 8.496E-15, 9.776E-14}, {800000.0, 7.069E-15, 8.059E-14}, {840000.0, 4.68E-15, 5.741E-14}, {880000.0, 3.2E-15, 4.21E-14}, {920000.0, 2.21E-15, 3.13E-14}, {960000.0, 1.56E-15, 2.36E-14}, {1000000.0, 1.15E-15, 1.81E-14}};
    private double n;
    private PVCoordinatesProvider sun;
    private OneAxisEllipsoid earth;
    private double[][] tabAltRho;

    public HarrisPriester(PVCoordinatesProvider sun, OneAxisEllipsoid earth) {
        this(sun, earth, ALT_RHO, 4.0);
    }

    public HarrisPriester(PVCoordinatesProvider sun, OneAxisEllipsoid earth, double n) {
        this(sun, earth, ALT_RHO, n);
    }

    public HarrisPriester(PVCoordinatesProvider sun, OneAxisEllipsoid earth, double[][] tabAltRho) {
        this(sun, earth, tabAltRho, 4.0);
    }

    public HarrisPriester(PVCoordinatesProvider sun, OneAxisEllipsoid earth, double[][] tabAltRho, double n) {
        this.sun = sun;
        this.earth = earth;
        this.setTabDensity(tabAltRho);
        this.setN(n);
    }

    @Override
    public Frame getFrame() {
        return this.earth.getBodyFrame();
    }

    private void setN(double n) {
        this.n = n;
    }

    private void setTabDensity(double[][] tab) {
        this.tabAltRho = new double[tab.length][];
        for (int i = 0; i < tab.length; ++i) {
            this.tabAltRho[i] = (double[])tab[i].clone();
        }
    }

    public double[][] getTabDensity() {
        double[][] copy = new double[this.tabAltRho.length][];
        for (int i = 0; i < this.tabAltRho.length; ++i) {
            copy[i] = (double[])this.tabAltRho[i].clone();
        }
        return copy;
    }

    public double getMinAlt() {
        return this.tabAltRho[0][0];
    }

    public double getMaxAlt() {
        return this.tabAltRho[this.tabAltRho.length - 1][0];
    }

    public double getDensity(Vector3D sunInEarth, Vector3D posInEarth) {
        int ia;
        double posAlt = this.getHeight(posInEarth);
        if (posAlt < this.getMinAlt()) {
            throw new OrekitException((Localizable)OrekitMessages.ALTITUDE_BELOW_ALLOWED_THRESHOLD, posAlt, this.getMinAlt());
        }
        if (posAlt > this.getMaxAlt()) {
            return 0.0;
        }
        Vector3D sunDir = (Vector3D)sunInEarth.normalize();
        Vector3D bulDir = new Vector3D(sunDir.getX() * SCLAG.cos() - sunDir.getY() * SCLAG.sin(), sunDir.getX() * SCLAG.sin() + sunDir.getY() * SCLAG.cos(), sunDir.getZ());
        double cosPsi = ((Vector3D)bulDir.normalize()).dotProduct(posInEarth.normalize());
        double c2Psi2 = (1.0 + cosPsi) / 2.0;
        double cPsi2 = FastMath.sqrt((double)c2Psi2);
        double cosPow = cPsi2 > 1.0E-12 ? c2Psi2 * FastMath.pow((double)cPsi2, (double)(this.n - 2.0)) : 0.0;
        for (ia = 0; ia < this.tabAltRho.length - 2 && posAlt > this.tabAltRho[ia + 1][0]; ++ia) {
        }
        double dH = (this.tabAltRho[ia][0] - posAlt) / (this.tabAltRho[ia][0] - this.tabAltRho[ia + 1][0]);
        double rhoMin = this.tabAltRho[ia][1] * FastMath.pow((double)(this.tabAltRho[ia + 1][1] / this.tabAltRho[ia][1]), (double)dH);
        if (Precision.equals((double)cosPow, (double)0.0)) {
            return rhoMin;
        }
        double rhoMax = this.tabAltRho[ia][2] * FastMath.pow((double)(this.tabAltRho[ia + 1][2] / this.tabAltRho[ia][2]), (double)dH);
        return rhoMin + (rhoMax - rhoMin) * cosPow;
    }

    public <T extends CalculusFieldElement<T>> T getDensity(Vector3D sunInEarth, FieldVector3D<T> posInEarth) {
        int ia;
        CalculusFieldElement zero = (CalculusFieldElement)posInEarth.getX().getField().getZero();
        T posAlt = this.getHeight(posInEarth);
        if (posAlt.getReal() < this.getMinAlt()) {
            throw new OrekitException((Localizable)OrekitMessages.ALTITUDE_BELOW_ALLOWED_THRESHOLD, posAlt, this.getMinAlt());
        }
        if (posAlt.getReal() > this.getMaxAlt()) {
            return (T)zero;
        }
        Vector3D sunDir = (Vector3D)sunInEarth.normalize();
        Vector3D bulDir = new Vector3D(sunDir.getX() * SCLAG.cos() - sunDir.getY() * SCLAG.sin(), sunDir.getX() * SCLAG.sin() + sunDir.getY() * SCLAG.cos(), sunDir.getZ());
        CalculusFieldElement cosPsi = posInEarth.normalize().dotProduct((Vector3D)bulDir.normalize());
        CalculusFieldElement c2Psi2 = (CalculusFieldElement)((CalculusFieldElement)cosPsi.add(1.0)).divide(2.0);
        CalculusFieldElement cPsi2 = (CalculusFieldElement)c2Psi2.sqrt();
        CalculusFieldElement cosPow = cPsi2.getReal() > 1.0E-12 ? (CalculusFieldElement)c2Psi2.multiply((FieldElement)((CalculusFieldElement)cPsi2.pow(this.n - 2.0))) : zero;
        for (ia = 0; ia < this.tabAltRho.length - 2 && posAlt.getReal() > this.tabAltRho[ia + 1][0]; ++ia) {
        }
        CalculusFieldElement dH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)posAlt.negate()).add(this.tabAltRho[ia][0])).divide(this.tabAltRho[ia][0] - this.tabAltRho[ia + 1][0]);
        CalculusFieldElement rhoMin = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(this.tabAltRho[ia + 1][1] / this.tabAltRho[ia][1])).pow((FieldElement)dH)).multiply(this.tabAltRho[ia][1]);
        if (Precision.equals((double)cosPow.getReal(), (double)0.0)) {
            return (T)rhoMin;
        }
        CalculusFieldElement rhoMax = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(this.tabAltRho[ia + 1][2] / this.tabAltRho[ia][2])).pow((FieldElement)dH)).multiply(this.tabAltRho[ia][2]);
        return (T)((CalculusFieldElement)rhoMin.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rhoMax.subtract((FieldElement)rhoMin)).multiply((FieldElement)cosPow))));
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) {
        Vector3D sunInEarth = this.sun.getPosition(date, this.earth.getBodyFrame());
        Vector3D posInEarth = frame.getStaticTransformTo(this.earth.getBodyFrame(), date).transformPosition(position);
        return this.getDensity(sunInEarth, posInEarth);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T getDensity(FieldAbsoluteDate<T> date, FieldVector3D<T> position, Frame frame) {
        Vector3D sunInEarth = this.sun.getPosition(date.toAbsoluteDate(), this.earth.getBodyFrame());
        FieldVector3D<T> posInEarth = frame.getStaticTransformTo(this.earth.getBodyFrame(), date.toAbsoluteDate()).transformPosition(position);
        return this.getDensity(sunInEarth, posInEarth);
    }

    private double getHeight(Vector3D position) {
        double a = this.earth.getEquatorialRadius();
        double f = this.earth.getFlattening();
        double e2 = f * (2.0 - f);
        double r = position.getNorm();
        double sl = position.getZ() / r;
        double cl2 = 1.0 - sl * sl;
        double coef = FastMath.sqrt((double)((1.0 - e2) / (1.0 - e2 * cl2)));
        return r - a * coef;
    }

    private <T extends CalculusFieldElement<T>> T getHeight(FieldVector3D<T> position) {
        double a = this.earth.getEquatorialRadius();
        double f = this.earth.getFlattening();
        double e2 = f * (2.0 - f);
        CalculusFieldElement r = position.getNorm();
        CalculusFieldElement sl = (CalculusFieldElement)position.getZ().divide((FieldElement)r);
        CalculusFieldElement cl2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sl.square()).negate()).add(1.0);
        CalculusFieldElement coef = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cl2.multiply(-e2)).add(1.0)).reciprocal()).multiply(1.0 - e2)).sqrt();
        return (T)((CalculusFieldElement)r.subtract((FieldElement)((CalculusFieldElement)coef.multiply(a))));
    }
}

