/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.atmosphere;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.FieldKinematicTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.KinematicTransform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public interface Atmosphere
extends Serializable {
    public Frame getFrame();

    public double getDensity(AbsoluteDate var1, Vector3D var2, Frame var3);

    public <T extends CalculusFieldElement<T>> T getDensity(FieldAbsoluteDate<T> var1, FieldVector3D<T> var2, Frame var3);

    default public Vector3D getVelocity(AbsoluteDate date, Vector3D position, Frame frame) {
        KinematicTransform bodyToFrame = this.getFrame().getKinematicTransformTo(frame, date);
        Vector3D posInBody = bodyToFrame.getStaticInverse().transformPosition(position);
        PVCoordinates pvBody = new PVCoordinates(posInBody, Vector3D.ZERO);
        PVCoordinates pvFrame = bodyToFrame.transformOnlyPV(pvBody);
        return pvFrame.getVelocity();
    }

    default public <T extends CalculusFieldElement<T>> FieldVector3D<T> getVelocity(FieldAbsoluteDate<T> date, FieldVector3D<T> position, Frame frame) {
        FieldKinematicTransform bodyToFrame = this.getFrame().getKinematicTransformTo(frame, date);
        FieldVector3D posInBody = bodyToFrame.getStaticInverse().transformPosition(position);
        FieldPVCoordinates pvBody = new FieldPVCoordinates(posInBody, FieldVector3D.getZero(date.getField()));
        FieldPVCoordinates<T> pvFrame = bodyToFrame.transformOnlyPV(pvBody);
        return pvFrame.getVelocity();
    }
}

