/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.utils.units.UnitsConverter;

public class GeoMagneticElements
implements Serializable {
    private static final long serialVersionUID = 1881493738280586855L;
    private Vector3D b;
    private double inclination;
    private double declination;
    private double totalIntensity;
    private double horizontalIntensity;

    public GeoMagneticElements(Vector3D b) {
        this.b = new Vector3D(UnitsConverter.NANO_TESLAS_TO_TESLAS.getFrom().getScale(), b);
        double intensityNanoTesla = FastMath.hypot((double)b.getX(), (double)b.getY());
        this.horizontalIntensity = UnitsConverter.NANO_TESLAS_TO_TESLAS.convert(intensityNanoTesla);
        this.totalIntensity = UnitsConverter.NANO_TESLAS_TO_TESLAS.convert(b.getNorm());
        this.declination = FastMath.atan2((double)b.getY(), (double)b.getX());
        this.inclination = FastMath.atan2((double)b.getZ(), (double)intensityNanoTesla);
    }

    public Vector3D getFieldVector() {
        return this.b;
    }

    public double getInclination() {
        return this.inclination;
    }

    public double getDeclination() {
        return this.declination;
    }

    public double getTotalIntensity() {
        return this.totalIntensity;
    }

    public double getHorizontalIntensity() {
        return this.horizontalIntensity;
    }

    public String toString() {
        NumberFormat f = NumberFormat.getInstance();
        DecimalFormat d = new DecimalFormat("0.######E0");
        StringBuilder sb = new StringBuilder();
        sb.append("MagneticField[");
        sb.append("B=");
        sb.append(this.b.toString((NumberFormat)d));
        sb.append(",H=");
        sb.append(d.format(this.getHorizontalIntensity()));
        sb.append(",F=");
        sb.append(d.format(this.getTotalIntensity()));
        sb.append(",I=");
        sb.append(f.format(this.getInclination()));
        sb.append(",D=");
        sb.append(f.format(this.getDeclination()));
        sb.append("]");
        return sb.toString();
    }
}

