/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.parser.Units;
import org.orekit.gnss.rflink.gps.SubFrame45;

public class SubFrameAlmanac
extends SubFrame45 {
    private static final int E = 9;
    private static final int TOA = 10;
    private static final int DELTA_I = 11;
    private static final int OMEGA_DOT = 12;
    private static final int SV_HEALTH = 13;
    private static final int SQRT_A = 14;
    private static final int UPPERCASE_OMEGA_0 = 15;
    private static final int LOWERCASE_OMEGA = 16;
    private static final int M0 = 17;
    private static final int AF0 = 18;
    private static final int AF1 = 19;

    SubFrameAlmanac(int[] words) {
        super(words, 20);
        this.setField(9, 3, 6, 16, words);
        this.setField(10, 4, 22, 8, words);
        this.setField(11, 4, 6, 16, words);
        this.setField(12, 5, 14, 16, words);
        this.setField(13, 5, 6, 8, words);
        this.setField(14, 6, 6, 24, words);
        this.setField(15, 7, 6, 24, words);
        this.setField(16, 8, 6, 24, words);
        this.setField(17, 9, 6, 24, words);
        this.setField(18, 10, 22, 8, 10, 8, 3, words);
        this.setField(19, 10, 11, 11, words);
    }

    public int getPRN() {
        return this.getSvId();
    }

    public double getE() {
        return FastMath.scalb((double)this.getField(9), (int)-21);
    }

    public int getToaA() {
        return this.getField(10) << 12;
    }

    public double getDeltai() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(11), (int)-19));
    }

    public double getOmegaDot() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(12), (int)-38));
    }

    public int getSvHealth() {
        return this.getField(13);
    }

    public double getSqrtA() {
        return FastMath.scalb((double)this.getField(14), (int)-11);
    }

    public double getUppercaseOmega0() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(15), (int)-23));
    }

    public double getLowercaseOmega() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(16), (int)-23));
    }

    public double getM0() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(17), (int)-23));
    }

    public double getAF0() {
        return FastMath.scalb((double)this.getField(18), (int)-20);
    }

    public double getAF1() {
        return FastMath.scalb((double)this.getField(19), (int)-38);
    }
}

