/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.MathUtils;
import org.orekit.gnss.rflink.gps.SubFrame45;

public class SubFrame5B
extends SubFrame45 {
    private static final int SVH_WORDS = 6;
    private static final int SVH_FIELDS = 4;
    private static final int TOA = 9;
    private static final int WEEK_NUMBER = 10;
    private static final int RESERVED_A_10 = 35;
    private static final int RESERVED_B_10 = 36;

    SubFrame5B(int[] words) {
        super(words, 37);
        this.setField(9, 3, 14, 8, words);
        this.setField(10, 3, 6, 8, words);
        int fieldIndex = 11;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.setField(fieldIndex++, 4 + i, 18 - 6 * j, 6, words);
            }
        }
        this.setField(35, 10, 24, 6, words);
        this.setField(36, 10, 8, 16, words);
    }

    public int getTOA() {
        return this.getField(9) << 12;
    }

    public int getWeekNumber() {
        return this.getField(10);
    }

    public int getSvHealth(int index) {
        MathUtils.checkRangeInclusive((long)index, (long)1L, (long)24L);
        return this.getField(10 + index);
    }

    public int getReservedA10() {
        return this.getField(35);
    }

    public int getReservedB10() {
        return this.getField(36);
    }
}

