/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.MathUtils;
import org.orekit.gnss.rflink.gps.SubFrame45;

public class SubFrame4E
extends SubFrame45 {
    public static final int NB_AS = 32;
    public static final int NB_SVH = 8;
    private static final int AS_SIZE = 4;
    private static final int SVH_SIZE = 6;
    private static final int FIRST_AS = 9;
    private static final int RESERVED_8 = 41;
    private static final int RESERVED_10 = 82;

    SubFrame4E(int[] words) {
        super(words, 83);
        int i;
        int field = 8;
        int word = 3;
        int shift = 22;
        for (i = 0; i < 32; ++i) {
            if (shift >= 10) {
                this.setField(++field, word, shift -= 4, 4, words);
                continue;
            }
            shift = 26;
            this.setField(++field, ++word, shift, 4, words);
        }
        this.setField(41, word, shift -= 2, 2, words);
        for (i = 0; i < 8; ++i) {
            if (shift >= 12) {
                this.setField(++field, word, shift -= 6, 6, words);
                continue;
            }
            shift = 24;
            this.setField(++field, ++word, shift, 6, words);
        }
        this.setField(82, 10, 8, 4, words);
    }

    public int getAntiSpoofing(int index) {
        MathUtils.checkRangeInclusive((long)index, (long)1L, (long)32L);
        return this.getField(9 + index - 1);
    }

    public int getReserved8() {
        return this.getField(41);
    }

    public int getSvHealth(int index) {
        MathUtils.checkRangeInclusive((long)index, (long)1L, (long)8L);
        return this.getField(41 + index);
    }

    public int getReserved10() {
        return this.getField(82);
    }
}

