/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.parser.Units;
import org.orekit.gnss.rflink.gps.SubFrame45;
import org.orekit.utils.units.Unit;

public class SubFrame4D
extends SubFrame45 {
    private static final Unit S_PER_SC = Unit.SECOND.divide("s/sc", Units.SEMI_CIRCLE);
    private static final Unit S_PER_SC2 = S_PER_SC.divide("s/sc\u00b2", Units.SEMI_CIRCLE);
    private static final Unit S_PER_SC3 = S_PER_SC2.divide("s/sc\u00b3", Units.SEMI_CIRCLE);
    private static final int ALPHA0 = 9;
    private static final int ALPHA1 = 10;
    private static final int ALPHA2 = 11;
    private static final int ALPHA3 = 12;
    private static final int BETA0 = 13;
    private static final int BETA1 = 14;
    private static final int BETA2 = 15;
    private static final int BETA3 = 16;
    private static final int A1 = 17;
    private static final int A0 = 18;
    private static final int TOT = 19;
    private static final int WEEK_NUMBER_T = 20;
    private static final int DELTA_T_LS = 21;
    private static final int WEEK_NUMBER_LSF = 22;
    private static final int DN = 23;
    private static final int DELTA_T_LSF = 24;
    private static final int RESERVED_10 = 25;

    SubFrame4D(int[] words) {
        super(words, 26);
        this.setField(9, 3, 14, 8, words);
        this.setField(10, 3, 6, 8, words);
        this.setField(11, 4, 22, 8, words);
        this.setField(12, 4, 14, 8, words);
        this.setField(13, 4, 6, 8, words);
        this.setField(14, 5, 22, 8, words);
        this.setField(15, 5, 14, 8, words);
        this.setField(16, 5, 6, 8, words);
        this.setField(17, 6, 6, 24, words);
        this.setField(18, 7, 6, 24, 8, 22, 8, words);
        this.setField(19, 8, 14, 8, words);
        this.setField(20, 8, 6, 8, words);
        this.setField(21, 9, 22, 8, words);
        this.setField(22, 9, 14, 8, words);
        this.setField(23, 9, 6, 8, words);
        this.setField(24, 10, 22, 8, words);
        this.setField(25, 10, 8, 14, words);
    }

    public double getAlpha0() {
        return FastMath.scalb((double)this.getField(9), (int)-30);
    }

    public double getAlpha1() {
        return S_PER_SC.toSI(FastMath.scalb((double)this.getField(10), (int)-27));
    }

    public double getAlpha2() {
        return S_PER_SC2.toSI(FastMath.scalb((double)this.getField(11), (int)-24));
    }

    public double getAlpha3() {
        return S_PER_SC3.toSI(FastMath.scalb((double)this.getField(12), (int)-24));
    }

    public double getBeta0() {
        return FastMath.scalb((double)this.getField(13), (int)11);
    }

    public double getBeta1() {
        return S_PER_SC.toSI(FastMath.scalb((double)this.getField(14), (int)14));
    }

    public double getBeta2() {
        return S_PER_SC2.toSI(FastMath.scalb((double)this.getField(15), (int)16));
    }

    public double getBeta3() {
        return S_PER_SC3.toSI(FastMath.scalb((double)this.getField(16), (int)16));
    }

    public double getA1() {
        return FastMath.scalb((double)this.getField(17), (int)-50);
    }

    public double getA0() {
        return FastMath.scalb((double)this.getField(18), (int)-30);
    }

    public int getTot() {
        return this.getField(19) << 12;
    }

    public int getWeekNumberT() {
        return this.getField(20);
    }

    public int getDeltaTLs() {
        return this.getField(21);
    }

    public int getWeekNumberLsf() {
        return this.getField(22);
    }

    public int getDn() {
        return this.getField(23);
    }

    public int getDeltaTLsf() {
        return this.getField(24);
    }

    public int getReserved10() {
        return this.getField(25);
    }
}

