/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.parser.Units;
import org.orekit.gnss.rflink.gps.SubFrame;

public class SubFrame3
extends SubFrame {
    private static final int CIC = 7;
    private static final int UPPERCASE_OMEGA_0 = 8;
    private static final int CIS = 9;
    private static final int I0 = 10;
    private static final int CRC = 11;
    private static final int LOWERCASE_OMEGA = 12;
    private static final int OMEGA_DOT = 13;
    private static final int IODE = 14;
    private static final int I_DOT = 15;

    SubFrame3(int[] words) {
        super(words, 16);
        this.setField(7, 3, 14, 16, words);
        this.setField(8, 3, 6, 8, 4, 6, 24, words);
        this.setField(9, 5, 14, 16, words);
        this.setField(10, 5, 6, 8, 6, 6, 24, words);
        this.setField(11, 7, 14, 16, words);
        this.setField(12, 7, 6, 8, 8, 6, 24, words);
        this.setField(13, 9, 6, 24, words);
        this.setField(14, 10, 22, 8, words);
        this.setField(15, 10, 8, 14, words);
    }

    public double getCic() {
        return FastMath.scalb((double)this.getField(7), (int)-29);
    }

    public double getUppercaseOmega0() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(8), (int)-31));
    }

    public double getCis() {
        return FastMath.scalb((double)this.getField(9), (int)-29);
    }

    public double getI0() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(10), (int)-31));
    }

    public double getCrc() {
        return FastMath.scalb((double)this.getField(11), (int)-5);
    }

    public double getLowercaseOmega() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(12), (int)-31));
    }

    public double getOmegaDot() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(13), (int)-43));
    }

    public int getIODE() {
        return this.getField(14);
    }

    public double getIDot() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(15), (int)-43));
    }
}

