/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.parser.Units;
import org.orekit.gnss.rflink.gps.SubFrame;

public class SubFrame2
extends SubFrame {
    private static final int IODE = 7;
    private static final int CRS = 8;
    private static final int DELTA_N = 9;
    private static final int M0 = 10;
    private static final int CUC = 11;
    private static final int E = 12;
    private static final int CUS = 13;
    private static final int SQRT_A = 14;
    private static final int TOE = 15;
    private static final int FIT_INTERVAL = 16;
    private static final int AODO = 17;

    SubFrame2(int[] words) {
        super(words, 18);
        this.setField(7, 3, 22, 8, words);
        this.setField(8, 3, 6, 16, words);
        this.setField(9, 4, 14, 16, words);
        this.setField(10, 4, 6, 8, 5, 6, 24, words);
        this.setField(11, 6, 14, 16, words);
        this.setField(12, 6, 6, 8, 7, 6, 24, words);
        this.setField(13, 8, 14, 16, words);
        this.setField(14, 8, 6, 8, 9, 6, 24, words);
        this.setField(15, 10, 14, 16, words);
        this.setField(16, 10, 13, 1, words);
        this.setField(17, 10, 8, 5, words);
    }

    public int getIODE() {
        return this.getField(7);
    }

    public double getCrs() {
        return FastMath.scalb((double)this.getField(8), (int)-5);
    }

    public double getDeltaN() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(9), (int)-43));
    }

    public double getM0() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(10), (int)-31));
    }

    public double getCuc() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(11), (int)-29));
    }

    public double getE() {
        return FastMath.scalb((double)this.getField(12), (int)-33);
    }

    public double getCus() {
        return Units.SEMI_CIRCLE.toSI(FastMath.scalb((double)this.getField(13), (int)-29));
    }

    public double getSqrtA() {
        return FastMath.scalb((double)this.getField(14), (int)-19);
    }

    public int getToe() {
        return this.getField(15) << 4;
    }

    public int getFitInterval() {
        return this.getField(16);
    }

    public int getAODO() {
        return this.getField(17) * 900;
    }
}

