/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.rflink.gps.SubFrame;

public class SubFrame1
extends SubFrame {
    private static final int WEEK_NUMBER = 7;
    private static final int CA_OR_P = 8;
    private static final int URA_INDEX = 9;
    private static final int SV_HEALTH = 10;
    private static final int IODC = 11;
    private static final int L2_P_DATA = 12;
    private static final int RESERVED_4 = 13;
    private static final int RESERVED_5 = 14;
    private static final int RESERVED_6 = 15;
    private static final int RESERVED_7 = 16;
    private static final int TGD = 17;
    private static final int TOC = 18;
    private static final int AF2 = 19;
    private static final int AF1 = 20;
    private static final int AF0 = 21;

    SubFrame1(int[] words) {
        super(words, 22);
        this.setField(7, 3, 20, 10, words);
        this.setField(8, 3, 18, 2, words);
        this.setField(9, 3, 14, 4, words);
        this.setField(10, 3, 8, 6, words);
        this.setField(11, 3, 6, 2, 8, 22, 8, words);
        this.setField(12, 4, 29, 1, words);
        this.setField(13, 4, 6, 23, words);
        this.setField(14, 5, 6, 24, words);
        this.setField(15, 6, 6, 24, words);
        this.setField(16, 7, 14, 16, words);
        this.setField(17, 7, 6, 8, words);
        this.setField(18, 8, 6, 16, words);
        this.setField(19, 9, 22, 8, words);
        this.setField(20, 9, 6, 16, words);
        this.setField(21, 10, 8, 22, words);
    }

    public int getWeekNumber() {
        return this.getField(7);
    }

    public int getCaOrPFlag() {
        return this.getField(8);
    }

    public int getUraIndex() {
        return this.getField(9);
    }

    public int getSvHealth() {
        return this.getField(10);
    }

    public int getIODC() {
        return this.getField(11);
    }

    public int getL2PDataFlag() {
        return this.getField(12);
    }

    public int getReserved04() {
        return this.getField(13);
    }

    public int getReserved05() {
        return this.getField(14);
    }

    public int getReserved06() {
        return this.getField(15);
    }

    public int getReserved07() {
        return this.getField(16);
    }

    public int getTGD() {
        return this.getField(17);
    }

    public int getTOC() {
        return this.getField(18);
    }

    public double getAF2() {
        return FastMath.scalb((double)this.getField(19), (int)-55);
    }

    public double getAF1() {
        return FastMath.scalb((double)this.getField(20), (int)-43);
    }

    public double getAF0() {
        return FastMath.scalb((double)this.getField(21), (int)-31);
    }
}

