/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.rflink.gps;

import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.metric.parser.EncodedMessage;
import org.orekit.gnss.rflink.gps.SubFrame1;
import org.orekit.gnss.rflink.gps.SubFrame2;
import org.orekit.gnss.rflink.gps.SubFrame3;
import org.orekit.gnss.rflink.gps.SubFrame4A0;
import org.orekit.gnss.rflink.gps.SubFrame4A1;
import org.orekit.gnss.rflink.gps.SubFrame4B;
import org.orekit.gnss.rflink.gps.SubFrame4C;
import org.orekit.gnss.rflink.gps.SubFrame4D;
import org.orekit.gnss.rflink.gps.SubFrame4E;
import org.orekit.gnss.rflink.gps.SubFrame5B;
import org.orekit.gnss.rflink.gps.SubFrameAlmanac;
import org.orekit.gnss.rflink.gps.SubFrameDummyAlmanac;

public abstract class SubFrame {
    public static final int PREAMBLE_VALUE = 139;
    protected static final int WORD_SIZE = 30;
    protected static final int PARITY_SIZE = 6;
    private static final int PREAMBLE = 0;
    private static final int MESSAGE = 1;
    private static final int INTEGRITY_STATUS = 2;
    private static final int TOW_COUNT = 3;
    private static final int ALERT = 4;
    private static final int ANTI_SPOOFING = 5;
    private static final int ID = 6;
    private final int[] fields;

    protected SubFrame(int[] words, int nbFields) {
        this.fields = new int[nbFields];
        this.setField(0, 1, 22, 8, words);
        this.setField(1, 1, 8, 14, words);
        this.setField(2, 1, 7, 1, words);
        this.setField(3, 2, 13, 17, words);
        this.setField(4, 2, 12, 1, words);
        this.setField(5, 2, 11, 1, words);
        this.setField(6, 2, 8, 3, words);
        if (this.getField(0) != 139) {
            throw new OrekitException((Localizable)OrekitMessages.INVALID_GNSS_DATA, this.getField(0));
        }
    }

    public static SubFrame parse(EncodedMessage encodedMessage) {
        int i;
        encodedMessage.start();
        int[] words = new int[10];
        for (i = 0; i < words.length; ++i) {
            words[i] = (int)encodedMessage.extractBits(30);
        }
        for (i = 0; i < words.length; ++i) {
            if (SubFrame.checkParity(i == 0 ? 0 : words[i - 1], words[i])) continue;
            throw new OrekitException((Localizable)OrekitMessages.GNSS_PARITY_ERROR, i + 1);
        }
        int id = words[1] >>> 8 & 7;
        switch (id) {
            case 1: {
                return new SubFrame1(words);
            }
            case 2: {
                return new SubFrame2(words);
            }
            case 3: {
                return new SubFrame3(words);
            }
            case 4: {
                int svId = words[2] >>> 22 & 0x3F;
                switch (svId) {
                    case 0: {
                        return new SubFrameDummyAlmanac(words);
                    }
                    case 57: {
                        return new SubFrame4A0(words);
                    }
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: {
                        return new SubFrameAlmanac(words);
                    }
                    case 53: 
                    case 54: 
                    case 55: {
                        return new SubFrame4B(words);
                    }
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        return new SubFrame4A1(words);
                    }
                    case 52: {
                        return new SubFrame4C(words);
                    }
                    case 56: {
                        return new SubFrame4D(words);
                    }
                    case 63: {
                        return new SubFrame4E(words);
                    }
                }
                throw new OrekitException((Localizable)OrekitMessages.INVALID_GNSS_DATA, svId);
            }
            case 5: {
                int page = words[2] >>> 22 & 0x3F;
                return page == 25 ? new SubFrame5B(words) : new SubFrameAlmanac(words);
            }
        }
        throw new OrekitException((Localizable)OrekitMessages.INVALID_GNSS_DATA, id);
    }

    public static boolean checkParity(int previous, int current) {
        int d30;
        int d29;
        int d28;
        int d27;
        int d26;
        int d29Star = previous & 2;
        int d30Star = previous & 1;
        int d25 = 1 & Integer.bitCount(d29Star | current & 0x3B1F3480);
        int parity = ((((d25 << 1 | (d26 = 1 & Integer.bitCount(d30Star | current & 0x1D8F9A40))) << 1 | (d27 = 1 & Integer.bitCount(d29Star | current & 0x2EC7CD00))) << 1 | (d28 = 1 & Integer.bitCount(d30Star | current & 0x1763E680))) << 1 | (d29 = 1 & Integer.bitCount(d30Star | current & 0x2BB1F340))) << 1 | (d30 = 1 & Integer.bitCount(d29Star | current & 0xB7A89C0));
        return (parity & 0x3F) == (current & 0x3F);
    }

    public boolean hasParityErrors() {
        return false;
    }

    protected int getField(int fieldIndex) {
        return this.fields[fieldIndex];
    }

    protected void setField(int fieldIndex, int wordIndex, int shift, int nbBits, int[] words) {
        this.fields[fieldIndex] = words[wordIndex - 1] >>> shift & (1 << nbBits) - 1;
    }

    protected void setField(int fieldIndex, int wordIndexMSB, int shiftMSB, int nbBitsMSB, int wordIndexLSB, int shiftLSB, int nbBitsLSB, int[] words) {
        int msb = words[wordIndexMSB - 1] >>> shiftMSB & (1 << nbBitsMSB) - 1;
        int lsb = words[wordIndexLSB - 1] >>> shiftLSB & (1 << nbBitsLSB) - 1;
        this.fields[fieldIndex] = msb << nbBitsLSB | lsb;
    }

    public int getPreamble() {
        return this.getField(0);
    }

    public int getMessage() {
        return this.getField(1);
    }

    public int getIntegrityStatus() {
        return this.getField(2);
    }

    public int getTow() {
        return this.getField(3) * 6;
    }

    public int getAlert() {
        return this.getField(4);
    }

    public int getAntiSpoofing() {
        return this.getField(5);
    }

    public int getId() {
        return this.getField(6);
    }
}

