/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.metric.messages.ParsedMessage;
import org.orekit.gnss.metric.messages.common.ClockCorrection;
import org.orekit.gnss.metric.messages.common.CodeBias;
import org.orekit.gnss.metric.messages.common.OrbitCorrection;
import org.orekit.gnss.metric.messages.common.PhaseBias;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm01;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm01Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm01Header;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm02;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm02Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm02Header;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm03;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm03Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm03Header;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm04;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm04Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm04Header;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm05;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm05Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm05Header;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm06;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm06Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm06Header;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm07;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm07Data;
import org.orekit.gnss.metric.messages.ssr.igm.SsrIgm07Header;
import org.orekit.gnss.metric.messages.ssr.subtype.SsrIm201;
import org.orekit.gnss.metric.messages.ssr.subtype.SsrIm201Data;
import org.orekit.gnss.metric.messages.ssr.subtype.SsrIm201Header;
import org.orekit.gnss.metric.parser.EncodedMessage;
import org.orekit.gnss.metric.parser.IgsSsrDataField;
import org.orekit.gnss.metric.parser.MessageType;

public enum IgsSsrMessageType implements MessageType
{
    IGM_01("21|41|61|81|101|121"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 1.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm01Header igm01Header = new SsrIgm01Header();
            igm01Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm01Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm01Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm01Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm01Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm01Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            igm01Header.setCrsIndicator(IgsSsrDataField.IDF006.intValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm01Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm01Data> igm01Data = new ArrayList<SsrIgm01Data>();
            for (int index = 0; index < satNumber; ++index) {
                int igm01SatId = 1.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage));
                int igm01Iod = IgsSsrDataField.IDF012.intValue(encodedMessage);
                OrbitCorrection igm01OrbitCorr = new OrbitCorrection(IgsSsrDataField.IDF013.doubleValue(encodedMessage), IgsSsrDataField.IDF014.doubleValue(encodedMessage), IgsSsrDataField.IDF015.doubleValue(encodedMessage), IgsSsrDataField.IDF016.doubleValue(encodedMessage), IgsSsrDataField.IDF017.doubleValue(encodedMessage), IgsSsrDataField.IDF018.doubleValue(encodedMessage));
                SsrIgm01Data currentIgm01Data = new SsrIgm01Data();
                currentIgm01Data.setSatelliteID(igm01SatId);
                currentIgm01Data.setGnssIod(igm01Iod);
                currentIgm01Data.setOrbitCorrection(igm01OrbitCorr);
                igm01Data.add(currentIgm01Data);
            }
            return new SsrIgm01(messageNumber, system, igm01Header, (List<SsrIgm01Data>)igm01Data);
        }
    }
    ,
    IGM_02("22|42|62|82|102|122"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 2.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm02Header igm02Header = new SsrIgm02Header();
            igm02Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm02Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm02Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm02Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm02Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm02Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm02Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm02Data> igm02Data = new ArrayList<SsrIgm02Data>();
            for (int index = 0; index < satNumber; ++index) {
                int igm02SatId = 2.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage));
                ClockCorrection igm02ClockCorr = new ClockCorrection(IgsSsrDataField.IDF019.doubleValue(encodedMessage), IgsSsrDataField.IDF020.doubleValue(encodedMessage), IgsSsrDataField.IDF021.doubleValue(encodedMessage));
                SsrIgm02Data currentIgm02Data = new SsrIgm02Data();
                currentIgm02Data.setSatelliteID(igm02SatId);
                currentIgm02Data.setClockCorrection(igm02ClockCorr);
                igm02Data.add(currentIgm02Data);
            }
            return new SsrIgm02(messageNumber, system, igm02Header, (List<SsrIgm02Data>)igm02Data);
        }
    }
    ,
    IGM_03("23|43|63|83|103|123"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 3.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm03Header igm03Header = new SsrIgm03Header();
            igm03Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm03Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm03Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm03Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm03Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm03Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            igm03Header.setCrsIndicator(IgsSsrDataField.IDF006.intValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm03Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm03Data> igm03Data = new ArrayList<SsrIgm03Data>();
            for (int index = 0; index < satNumber; ++index) {
                int igm03SatId = 3.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage));
                int igm03Iod = IgsSsrDataField.IDF012.intValue(encodedMessage);
                OrbitCorrection igm03OrbitCorr = new OrbitCorrection(IgsSsrDataField.IDF013.doubleValue(encodedMessage), IgsSsrDataField.IDF014.doubleValue(encodedMessage), IgsSsrDataField.IDF015.doubleValue(encodedMessage), IgsSsrDataField.IDF016.doubleValue(encodedMessage), IgsSsrDataField.IDF017.doubleValue(encodedMessage), IgsSsrDataField.IDF018.doubleValue(encodedMessage));
                ClockCorrection igm03ClockCorr = new ClockCorrection(IgsSsrDataField.IDF019.doubleValue(encodedMessage), IgsSsrDataField.IDF020.doubleValue(encodedMessage), IgsSsrDataField.IDF021.doubleValue(encodedMessage));
                SsrIgm03Data currentIgm03Data = new SsrIgm03Data();
                currentIgm03Data.setSatelliteID(igm03SatId);
                currentIgm03Data.setGnssIod(igm03Iod);
                currentIgm03Data.setOrbitCorrection(igm03OrbitCorr);
                currentIgm03Data.setClockCorrection(igm03ClockCorr);
                igm03Data.add(currentIgm03Data);
            }
            return new SsrIgm03(messageNumber, system, igm03Header, (List<SsrIgm03Data>)igm03Data);
        }
    }
    ,
    IGM_04("24|44|64|84|104|124"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 4.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm04Header igm04Header = new SsrIgm04Header();
            igm04Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm04Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm04Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm04Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm04Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm04Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm04Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm04Data> igm04Data = new ArrayList<SsrIgm04Data>();
            for (int index = 0; index < satNumber; ++index) {
                SsrIgm04Data currentIgm04Data = new SsrIgm04Data();
                currentIgm04Data.setSatelliteID(4.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage)));
                currentIgm04Data.setHighRateClockCorrection(IgsSsrDataField.IDF022.doubleValue(encodedMessage));
                igm04Data.add(currentIgm04Data);
            }
            return new SsrIgm04(messageNumber, system, igm04Header, (List<SsrIgm04Data>)igm04Data);
        }
    }
    ,
    IGM_05("25|45|65|85|105|125"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 5.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm05Header igm05Header = new SsrIgm05Header();
            igm05Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm05Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm05Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm05Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm05Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm05Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm05Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm05Data> igm05Data = new ArrayList<SsrIgm05Data>();
            for (int index = 0; index < satNumber; ++index) {
                SsrIgm05Data currentIgm05Data = new SsrIgm05Data();
                currentIgm05Data.setSatelliteID(5.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage)));
                int biasesNumber = IgsSsrDataField.IDF023.intValue(encodedMessage);
                currentIgm05Data.setNumberOfBiasesProcessed(biasesNumber);
                for (int biasIndex = 0; biasIndex < biasesNumber; ++biasIndex) {
                    CodeBias codeBias = new CodeBias(IgsSsrDataField.IDF024.intValue(encodedMessage), IgsSsrDataField.IDF025.doubleValue(encodedMessage));
                    currentIgm05Data.addCodeBias(codeBias);
                }
                igm05Data.add(currentIgm05Data);
            }
            return new SsrIgm05(messageNumber, system, igm05Header, (List<SsrIgm05Data>)igm05Data);
        }
    }
    ,
    IGM_06("26|46|66|86|106|126"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 6.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm06Header igm06Header = new SsrIgm06Header();
            igm06Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm06Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm06Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm06Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm06Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm06Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            igm06Header.setIsConsistencyMaintained(IgsSsrDataField.IDF032.booleanValue(encodedMessage));
            igm06Header.setIsMelbourneWubbenaConsistencyMaintained(IgsSsrDataField.IDF033.booleanValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm06Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm06Data> igm06Data = new ArrayList<SsrIgm06Data>();
            for (int index = 0; index < satNumber; ++index) {
                SsrIgm06Data currentIgm06Data = new SsrIgm06Data();
                currentIgm06Data.setSatelliteID(6.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage)));
                int biasesNumber = IgsSsrDataField.IDF023.intValue(encodedMessage);
                currentIgm06Data.setNumberOfBiasesProcessed(biasesNumber);
                currentIgm06Data.setYawAngle(IgsSsrDataField.IDF026.doubleValue(encodedMessage));
                currentIgm06Data.setYawRate(IgsSsrDataField.IDF027.doubleValue(encodedMessage));
                for (int biasIndex = 0; biasIndex < biasesNumber; ++biasIndex) {
                    PhaseBias phaseBias = new PhaseBias(IgsSsrDataField.IDF024.intValue(encodedMessage), IgsSsrDataField.IDF029.booleanValue(encodedMessage), IgsSsrDataField.IDF030.intValue(encodedMessage), IgsSsrDataField.IDF031.intValue(encodedMessage), IgsSsrDataField.IDF028.doubleValue(encodedMessage));
                    currentIgm06Data.addPhaseBias(phaseBias);
                }
                igm06Data.add(currentIgm06Data);
            }
            return new SsrIgm06(messageNumber, system, igm06Header, (List<SsrIgm06Data>)igm06Data);
        }
    }
    ,
    IGM_07("27|47|67|87|107|127"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SatelliteSystem system = 7.messageNumberToSatelliteSystem(messageNumber);
            SsrIgm07Header igm07Header = new SsrIgm07Header();
            igm07Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            igm07Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            igm07Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            igm07Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            igm07Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            igm07Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            int satNumber = IgsSsrDataField.IDF010.intValue(encodedMessage);
            igm07Header.setNumberOfSatellites(satNumber);
            ArrayList<SsrIgm07Data> igm07Data = new ArrayList<SsrIgm07Data>();
            for (int index = 0; index < satNumber; ++index) {
                SsrIgm07Data currentIgm07Data = new SsrIgm07Data();
                currentIgm07Data.setSatelliteID(7.getSatelliteId(system, IgsSsrDataField.IDF011.intValue(encodedMessage)));
                currentIgm07Data.setSsrUra(IgsSsrDataField.IDF034.intValue(encodedMessage));
                igm07Data.add(currentIgm07Data);
            }
            return new SsrIgm07(messageNumber, system, igm07Header, (List<SsrIgm07Data>)igm07Data);
        }
    }
    ,
    IM_201("201"){

        @Override
        public ParsedMessage parse(EncodedMessage encodedMessage, int messageNumber) {
            SsrIm201Header im201Header = new SsrIm201Header();
            im201Header.setSsrEpoch1s(IgsSsrDataField.IDF003.intValue(encodedMessage));
            im201Header.setSsrUpdateInterval(IgsSsrDataField.IDF004.intValue(encodedMessage));
            im201Header.setSsrMultipleMessageIndicator(IgsSsrDataField.IDF005.intValue(encodedMessage));
            im201Header.setIodSsr(IgsSsrDataField.IDF007.intValue(encodedMessage));
            im201Header.setSsrProviderId(IgsSsrDataField.IDF008.intValue(encodedMessage));
            im201Header.setSsrSolutionId(IgsSsrDataField.IDF009.intValue(encodedMessage));
            im201Header.setVtecQualityIndicator(IgsSsrDataField.IDF041.doubleValue(encodedMessage));
            int numberOfIonosphericLayers = IgsSsrDataField.IDF035.intValue(encodedMessage);
            im201Header.setNumberOfIonosphericLayers(numberOfIonosphericLayers);
            ArrayList<SsrIm201Data> im201Data = new ArrayList<SsrIm201Data>();
            for (int layerIndex = 0; layerIndex < numberOfIonosphericLayers; ++layerIndex) {
                int degree;
                int order;
                SsrIm201Data currentIm201Data = new SsrIm201Data();
                currentIm201Data.setHeightIonosphericLayer(IgsSsrDataField.IDF036.doubleValue(encodedMessage));
                int n = IgsSsrDataField.IDF037.intValue(encodedMessage);
                int m = IgsSsrDataField.IDF038.intValue(encodedMessage);
                double[][] cnm = new double[n + 1][m + 1];
                double[][] snm = new double[n + 1][m + 1];
                for (order = 0; order <= m; ++order) {
                    for (degree = order; degree <= n; ++degree) {
                        cnm[degree][order] = IgsSsrDataField.IDF039.doubleValue(encodedMessage);
                    }
                }
                for (order = 1; order <= m; ++order) {
                    for (degree = order; degree <= n; ++degree) {
                        snm[degree][order] = IgsSsrDataField.IDF040.doubleValue(encodedMessage);
                    }
                }
                currentIm201Data.setSphericalHarmonicsDegree(n);
                currentIm201Data.setSphericalHarmonicsOrder(m);
                currentIm201Data.setCnm(cnm);
                currentIm201Data.setSnm(snm);
                im201Data.add(currentIm201Data);
            }
            return new SsrIm201(messageNumber, im201Header, (List<SsrIm201Data>)im201Data);
        }
    };

    private static final Map<Pattern, IgsSsrMessageType> CODES_MAP;
    private final Pattern pattern;

    private IgsSsrMessageType(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public static IgsSsrMessageType getMessageType(String number) {
        for (Map.Entry<Pattern, IgsSsrMessageType> entry : CODES_MAP.entrySet()) {
            Matcher matcher = entry.getKey().matcher(number);
            if (!matcher.matches()) continue;
            return entry.getValue();
        }
        throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ENCODED_MESSAGE_NUMBER, number);
    }

    public static SatelliteSystem messageNumberToSatelliteSystem(int subTypeMessage) {
        if (subTypeMessage > 20 && subTypeMessage <= 40) {
            return SatelliteSystem.GPS;
        }
        if (subTypeMessage <= 60) {
            return SatelliteSystem.GLONASS;
        }
        if (subTypeMessage <= 80) {
            return SatelliteSystem.GALILEO;
        }
        if (subTypeMessage <= 100) {
            return SatelliteSystem.QZSS;
        }
        if (subTypeMessage <= 120) {
            return SatelliteSystem.BEIDOU;
        }
        if (subTypeMessage <= 140) {
            return SatelliteSystem.SBAS;
        }
        return SatelliteSystem.IRNSS;
    }

    public static int getSatelliteId(SatelliteSystem system, int id) {
        switch (system) {
            case QZSS: {
                return id + 192;
            }
            case SBAS: {
                return id + 119;
            }
        }
        return id;
    }

    static {
        CODES_MAP = new HashMap<Pattern, IgsSsrMessageType>();
        for (IgsSsrMessageType type : IgsSsrMessageType.values()) {
            CODES_MAP.put(type.getPattern(), type);
        }
    }
}

