/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.metric.messages.ParsedMessage;
import org.orekit.gnss.metric.ntrip.MessageObserver;
import org.orekit.gnss.metric.ntrip.NtripClient;
import org.orekit.gnss.metric.ntrip.Type;
import org.orekit.gnss.metric.parser.AbstractEncodedMessage;
import org.orekit.gnss.metric.parser.MessagesParser;

public class StreamMonitor
extends AbstractEncodedMessage
implements Runnable {
    private static final String GGA_HEADER_KEY = "Ntrip-GGA";
    private static final String GNSS_DATA_CONTENT_TYPE = "gnss/data";
    private static final int BUFFER_SIZE = 16384;
    private static final int PREAMBLE = 211;
    private static final int PREAMBLE_SIZE = 3;
    private static final int CRC_SIZE = 3;
    private static final int GENERATOR = 25578747;
    private static final int HIGH = 0x1000000;
    private static final int[] CRC_LOOKUP = new int[256];
    private final NtripClient client;
    private final String mountPoint;
    private final Type type;
    private final boolean nmeaRequired;
    private final boolean ignoreUnknownMessageTypes;
    private final double reconnectDelay;
    private final double reconnectDelayFactor;
    private final int maxRetries;
    private AtomicBoolean stop;
    private byte[] buffer;
    private int readIndex;
    private int messageEndIndex;
    private int writeIndex;
    private final Map<Integer, List<MessageObserver>> observers;
    private final Map<Integer, ParsedMessage> lastMessages;
    private final AtomicReference<OrekitException> exception;

    public StreamMonitor(NtripClient client, String mountPoint, Type type, boolean requiresNMEA, boolean ignoreUnknownMessageTypes, double reconnectDelay, double reconnectDelayFactor, int maxRetries) {
        this.client = client;
        this.mountPoint = mountPoint;
        this.type = type;
        this.nmeaRequired = requiresNMEA;
        this.ignoreUnknownMessageTypes = ignoreUnknownMessageTypes;
        this.reconnectDelay = reconnectDelay;
        this.reconnectDelayFactor = reconnectDelayFactor;
        this.maxRetries = maxRetries;
        this.stop = new AtomicBoolean(false);
        this.observers = new HashMap<Integer, List<MessageObserver>>();
        this.lastMessages = new HashMap<Integer, ParsedMessage>();
        this.exception = new AtomicReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(int typeCode, MessageObserver observer) {
        Map<Integer, List<MessageObserver>> map = this.observers;
        synchronized (map) {
            this.observers.computeIfAbsent(typeCode, tc -> new ArrayList()).add(observer);
            ParsedMessage last = this.lastMessages.get(typeCode);
            if (last != null) {
                observer.messageAvailable(this.mountPoint, last);
            }
        }
    }

    public void stopMonitoring() {
        this.stop.set(true);
    }

    public OrekitException getException() {
        return this.exception.get();
    }

    @Override
    public void run() {
        try {
            MessagesParser parser = this.type.getParser(this.extractUsedMessages());
            int nbAttempts = 0;
            double delay = this.reconnectDelay;
            while (nbAttempts < this.maxRetries) {
                try {
                    int responseCode;
                    HttpURLConnection connection = this.client.connect(this.mountPoint);
                    if (this.nmeaRequired) {
                        if (this.client.getGGA() == null) {
                            throw new OrekitException((Localizable)OrekitMessages.STREAM_REQUIRES_NMEA_FIX, this.mountPoint);
                        }
                        connection.setRequestProperty(GGA_HEADER_KEY, this.client.getGGA());
                    }
                    if ((responseCode = connection.getResponseCode()) == 401) {
                        throw new OrekitException((Localizable)OrekitMessages.FAILED_AUTHENTICATION, this.mountPoint);
                    }
                    if (responseCode != 200) {
                        throw new OrekitException((Localizable)OrekitMessages.CONNECTION_ERROR, connection.getURL().getHost(), connection.getResponseMessage());
                    }
                    if (!GNSS_DATA_CONTENT_TYPE.equals(connection.getContentType())) {
                        throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_CONTENT_TYPE, connection.getContentType());
                    }
                    this.resetCircularBuffer();
                    try (InputStream is = connection.getInputStream();){
                        int r = this.fillUp(is);
                        while (r >= 0) {
                            nbAttempts = 0;
                            delay = this.reconnectDelay;
                            if (this.stop.get()) {
                                return;
                            }
                            while (this.bufferSize() >= 3) {
                                if (this.peekByte(0) != 211) {
                                    this.moveRead(1);
                                    continue;
                                }
                                int size = (this.peekByte(1) & 3) << 8 | this.peekByte(2);
                                if (this.bufferSize() < 3 + size + 3) break;
                                int crc = this.peekByte(3 + size) << 16 | this.peekByte(3 + size + 1) << 8 | this.peekByte(3 + size + 2);
                                if (crc == this.computeCRC(3 + size)) {
                                    this.messageEndIndex = (this.readIndex + 3 + size) % 16384;
                                    this.moveRead(3);
                                    this.start();
                                    ParsedMessage message = parser.parse(this, this.ignoreUnknownMessageTypes);
                                    if (message != null) {
                                        this.storeAndNotify(message);
                                    }
                                    this.readIndex = (this.messageEndIndex + 3) % 16384;
                                    continue;
                                }
                                this.moveRead(1);
                            }
                            r = this.fillUp(is);
                        }
                    }
                }
                catch (SocketTimeoutException connection) {
                }
                catch (IOException | URISyntaxException e) {
                    throw new OrekitException(e, OrekitMessages.CANNOT_PARSE_GNSS_DATA, this.client.getHost());
                }
                try {
                    Thread.sleep((int)FastMath.rint((double)(delay * 1000.0)));
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                ++nbAttempts;
                delay *= this.reconnectDelayFactor;
            }
        }
        catch (OrekitException oe) {
            this.exception.set(oe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAndNotify(ParsedMessage message) {
        Map<Integer, List<MessageObserver>> map = this.observers;
        synchronized (map) {
            for (int typeCode : Arrays.asList(0, message.getTypeCode())) {
                this.lastMessages.put(typeCode, message);
                List<MessageObserver> list = this.observers.get(typeCode);
                if (list == null) continue;
                for (MessageObserver observer : list) {
                    observer.messageAvailable(this.mountPoint, message);
                }
            }
        }
    }

    private void resetCircularBuffer() {
        this.buffer = new byte[16384];
        this.readIndex = 0;
        this.writeIndex = 0;
    }

    private int fillUp(InputStream is) throws IOException {
        int max = this.bufferMaxWrite();
        if (max == 0) {
            throw new OrekitInternalError(null);
        }
        int r = is.read(this.buffer, this.writeIndex, max);
        if (r >= 0) {
            this.writeIndex = (this.writeIndex + r) % 16384;
        }
        return r;
    }

    @Override
    protected int fetchByte() {
        if (this.readIndex == this.messageEndIndex || this.readIndex == this.writeIndex) {
            return -1;
        }
        int ret = this.buffer[this.readIndex] & 0xFF;
        this.moveRead(1);
        return ret;
    }

    private int bufferSize() {
        int n = this.writeIndex - this.readIndex;
        return n >= 0 ? n : 16384 + n;
    }

    private int peekByte(int offset) {
        return this.buffer[(this.readIndex + offset) % 16384] & 0xFF;
    }

    private void moveRead(int n) {
        this.readIndex = (this.readIndex + n) % 16384;
    }

    private int bufferMaxWrite() {
        if (this.writeIndex >= this.readIndex) {
            return (this.readIndex == 0 ? 16383 : 16384) - this.writeIndex;
        }
        return this.readIndex - this.writeIndex - 1;
    }

    private int computeCRC(int length) {
        int crc = 0;
        for (int i = 0; i < length; ++i) {
            crc = (crc << 8 ^ CRC_LOOKUP[this.peekByte(i) ^ crc >>> 16]) & 0xFFFFFF;
        }
        return crc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> extractUsedMessages() {
        Map<Integer, List<MessageObserver>> map = this.observers;
        synchronized (map) {
            ArrayList<Integer> messages = new ArrayList<Integer>();
            for (Map.Entry<Integer, List<MessageObserver>> entry : this.observers.entrySet()) {
                int typeCode = entry.getKey();
                messages.add(typeCode);
            }
            return messages;
        }
    }

    static {
        StreamMonitor.CRC_LOOKUP[0] = 0;
        StreamMonitor.CRC_LOOKUP[1] = 25578747;
        int h = 25578747;
        for (int i = 2; i < 256; i <<= 1) {
            if (((h <<= 1) & 0x1000000) != 0) {
                h ^= 0x1864CFB;
            }
            for (int j = 0; j < i; ++j) {
                StreamMonitor.CRC_LOOKUP[i + j] = CRC_LOOKUP[j] ^ h;
            }
        }
    }
}

