/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.orekit.gnss.metric.ntrip.RecordType;

public abstract class Record {
    private static final Pattern SEPARATOR = Pattern.compile(";");
    private static final String QUOTE = "\"";
    private final List<String> fields;

    protected Record(String line) {
        String[] chunks = SEPARATOR.split(line);
        this.fields = new ArrayList<String>(chunks.length);
        for (int i = 0; i < chunks.length; ++i) {
            if (i > 0 && chunks[i - 1].endsWith(QUOTE) && i < chunks.length && chunks[i].startsWith(QUOTE)) {
                String before = this.fields.remove(this.fields.size() - 1);
                this.fields.add(before.substring(0, before.length() - 1) + SEPARATOR + chunks[i].substring(1));
                continue;
            }
            this.fields.add(chunks[i]);
        }
    }

    public abstract RecordType getRecordType();

    protected int getFieldsNumber() {
        return this.fields.size();
    }

    protected String getField(int index) {
        return this.fields.get(index);
    }

    public String getMisc() {
        return this.getField(this.getFieldsNumber() - 1);
    }
}

