/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.ntrip.Authentication;
import org.orekit.gnss.metric.ntrip.CarrierPhase;
import org.orekit.gnss.metric.ntrip.DataFormat;
import org.orekit.gnss.metric.ntrip.NavigationSystem;
import org.orekit.gnss.metric.ntrip.Record;
import org.orekit.gnss.metric.ntrip.RecordType;
import org.orekit.gnss.metric.ntrip.StreamedMessage;

public class DataStreamRecord
extends Record {
    private static final Pattern SEPARATOR = Pattern.compile(",");
    private static final Pattern PATTERN = Pattern.compile("^([^()]+)(?:\\(([0-9]+)\\))?$");
    private final DataFormat format = DataFormat.getDataFormat(this.getField(3));
    private final List<StreamedMessage> formatDetails;
    private final CarrierPhase carrierPhase;
    private final List<NavigationSystem> systems;
    private final double latitude;
    private final double longitude;
    private final boolean nmeaRequired;
    private final boolean networked;
    private final Authentication authentication;
    private final boolean fees;
    private int bitRate;

    public DataStreamRecord(String line) {
        super(line);
        String[] detailsFields = SEPARATOR.split(this.getField(4));
        this.formatDetails = new ArrayList<StreamedMessage>(detailsFields.length);
        for (String field : detailsFields) {
            if (field.isEmpty()) continue;
            Matcher matcher = PATTERN.matcher(field);
            if (matcher.matches() && matcher.start(2) >= 0) {
                this.formatDetails.add(new StreamedMessage(matcher.group(1), Integer.parseInt(matcher.group(2))));
                continue;
            }
            this.formatDetails.add(new StreamedMessage(field, -1));
        }
        this.carrierPhase = CarrierPhase.getCarrierPhase(this.getField(5));
        this.systems = Stream.of(this.getField(6).split("\\+")).map(k -> NavigationSystem.getNavigationSystem(k)).collect(Collectors.toList());
        this.latitude = FastMath.toRadians((double)Double.parseDouble(this.getField(9)));
        this.longitude = FastMath.toRadians((double)Double.parseDouble(this.getField(10)));
        this.nmeaRequired = Integer.parseInt(this.getField(11)) != 0;
        this.networked = Integer.parseInt(this.getField(12)) != 0;
        this.authentication = Authentication.getAuthentication(this.getField(15));
        this.fees = this.getField(16).equals("Y");
        this.bitRate = Integer.parseInt(this.getField(17));
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.STR;
    }

    public String getMountPoint() {
        return this.getField(1);
    }

    public String getSourceIdentifier() {
        return this.getField(2);
    }

    public DataFormat getFormat() {
        return this.format;
    }

    public List<StreamedMessage> getFormatDetails() {
        return this.formatDetails;
    }

    public CarrierPhase getCarrierPhase() {
        return this.carrierPhase;
    }

    public List<NavigationSystem> getNavigationSystems() {
        return this.systems;
    }

    public String getNetwork() {
        return this.getField(7);
    }

    public String getCountry() {
        return this.getField(8);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isNMEARequired() {
        return this.nmeaRequired;
    }

    public boolean isNetworked() {
        return this.networked;
    }

    public String getGenerator() {
        return this.getField(13);
    }

    public String getCompressionEncryption() {
        return this.getField(14);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean areFeesRequired() {
        return this.fees;
    }

    public int getBitRate() {
        return this.bitRate;
    }
}

