/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.ntrip;

import org.hipparchus.util.FastMath;
import org.orekit.gnss.metric.ntrip.Record;
import org.orekit.gnss.metric.ntrip.RecordType;

public class CasterRecord
extends Record {
    private final int port = Integer.parseInt(this.getField(2));
    private final int fallbackPort;
    private final boolean canReceiveNMEA = Integer.parseInt(this.getField(5)) != 0;
    private final double latitude = FastMath.toRadians((double)Double.parseDouble(this.getField(7)));
    private final double longitude = FastMath.toRadians((double)Double.parseDouble(this.getField(8)));

    public CasterRecord(String line) {
        super(line);
        this.fallbackPort = Integer.parseInt(this.getField(10));
    }

    @Override
    public RecordType getRecordType() {
        return RecordType.CAS;
    }

    public String getHostOrIPAddress() {
        return this.getField(1);
    }

    public int getPort() {
        return this.port;
    }

    public String getSourceIdentifier() {
        return this.getField(3);
    }

    public String getOperator() {
        return this.getField(4);
    }

    public boolean canReceiveNMEA() {
        return this.canReceiveNMEA;
    }

    public String getCountry() {
        return this.getField(6);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getFallbackHostOrIPAddress() {
        return this.getField(9);
    }

    public int getFallbackPort() {
        return this.fallbackPort;
    }
}

