/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.messages.rtcm.ephemeris;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.metric.messages.rtcm.ephemeris.RtcmEphemerisData;
import org.orekit.propagation.analytical.gnss.data.QZSSLegacyNavigationMessage;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class Rtcm1044Data
extends RtcmEphemerisData {
    private QZSSLegacyNavigationMessage qzssNavigationMessage;
    private double qzssToc;
    private int qzssCodeOnL2;
    private int qzssFitInterval;

    @DefaultDataContext
    public QZSSLegacyNavigationMessage getQzssNavigationMessage() {
        return this.getQzssNavigationMessage(DataContext.getDefault().getTimeScales());
    }

    public QZSSLegacyNavigationMessage getQzssNavigationMessage(TimeScales timeScales) {
        SatelliteSystem system = SatelliteSystem.QZSS;
        int week = this.qzssNavigationMessage.getWeek();
        double toe = this.qzssNavigationMessage.getTime();
        this.qzssNavigationMessage.setDate(new GNSSDate(week, toe, system, timeScales).getDate());
        this.qzssNavigationMessage.setEpochToc(new GNSSDate(week, this.qzssToc, system, timeScales).getDate());
        return this.qzssNavigationMessage;
    }

    public void setQzssNavigationMessage(QZSSLegacyNavigationMessage qzssNavigationMessage) {
        this.qzssNavigationMessage = qzssNavigationMessage;
    }

    public double getQzssToc() {
        return this.qzssToc;
    }

    public void setQzssToc(double toc) {
        this.qzssToc = toc;
    }

    public int getQzssCodeOnL2() {
        return this.qzssCodeOnL2;
    }

    public void setQzssCodeOnL2(int qzssCodeOnL2) {
        this.qzssCodeOnL2 = qzssCodeOnL2;
    }

    public int getQzssFitInterval() {
        return this.qzssFitInterval;
    }

    public void setQzssFitInterval(int qzssFitInterval) {
        this.qzssFitInterval = qzssFitInterval;
    }
}

