/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.metric.messages.rtcm.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.gnss.metric.messages.rtcm.RtcmMessage;
import org.orekit.gnss.metric.messages.rtcm.correction.RtcmCorrectionData;
import org.orekit.gnss.metric.messages.rtcm.correction.RtcmCorrectionHeader;

public class RtcmCorrectionMessage<H extends RtcmCorrectionHeader, D extends RtcmCorrectionData>
extends RtcmMessage<D> {
    private final H header;
    private final SatelliteSystem system;

    public RtcmCorrectionMessage(int typeCode, SatelliteSystem system, H header, List<D> data) {
        super(typeCode, data);
        this.header = header;
        this.system = system;
    }

    public H getHeader() {
        return this.header;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.system;
    }

    public Map<String, List<D>> getDataMap() {
        HashMap data = new HashMap();
        for (RtcmCorrectionData currentData : this.getData()) {
            int satId = currentData.getSatelliteID();
            String idString = satId < 10 ? "0" + String.valueOf(satId) : String.valueOf(satId);
            String id = this.getSatelliteSystem().getKey() + idString;
            data.putIfAbsent(id, new ArrayList());
            ((List)data.get(id)).add(currentData);
        }
        return Collections.unmodifiableMap(data);
    }
}

