/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.CalculusFieldUnivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.AllowedSolution;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.FieldBracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class Glonass
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_RATE = FastMath.toRadians((double)0.25);
    private static final double NIGHT_TURN_LIMIT = FastMath.toRadians((double)165.8);
    private static final double YAW_END_ZERO = FastMath.toRadians((double)75.0);
    private static final double END_MARGIN = 0.0;
    private final double yawRate;

    public Glonass(double yawRate, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double realBeta = context.beta(context.getDate());
        double muRate = context.getMuRate();
        double aNight = NIGHT_TURN_LIMIT;
        double aNoon = FastMath.atan((double)(muRate / this.yawRate));
        if (FastMath.abs((double)realBeta) < aNoon) {
            UnivariateFunction f = yawEnd -> {
                double delta = muRate * yawEnd / this.yawRate;
                return yawEnd - 0.5 * FastMath.abs((double)(context.computePhi(realBeta, delta) - context.computePhi(realBeta, -delta)));
            };
            double[] bracket = UnivariateSolverUtils.bracket((UnivariateFunction)f, (double)YAW_END_ZERO, (double)0.0, (double)Math.PI);
            double yawEnd2 = new BracketingNthOrderBrentSolver(1.0E-14, 1.0E-8, 1.0E-15, 5).solve(50, f, bracket[0], bracket[1], AllowedSolution.ANY_SIDE);
            aNoon = muRate * yawEnd2 / this.yawRate;
        }
        double cNoon = FastMath.cos((double)aNoon);
        double cNight = FastMath.cos((double)aNight);
        if (context.setUpTurnRegion(cNight, cNoon)) {
            context.setHalfSpan(context.inSunSide() ? aNoon : context.inOrbitPlaneAbsoluteAngle(aNight - Math.PI), 0.0);
            if (context.inTurnTimeRange()) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart();
                double phiEnd = context.getYawEnd(beta);
                if (context.inSunSide()) {
                    phiDot = -FastMath.copySign((double)this.yawRate, (double)beta);
                    linearPhi = phiStart + phiDot * dtStart;
                } else {
                    phiDot = FastMath.copySign((double)this.yawRate, (double)beta);
                    linearPhi = phiStart + phiDot * dtStart;
                    if (phiEnd / linearPhi < 0.0 || phiEnd / linearPhi > 1.0) {
                        return context.turnCorrectedAttitude(phiEnd, 0.0);
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends CalculusFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        Object realBeta = context.beta(context.getDate());
        Object muRate = context.getMuRate();
        CalculusFieldElement aNight = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(NIGHT_TURN_LIMIT);
        CalculusFieldElement aNoon = FastMath.atan((CalculusFieldElement)((CalculusFieldElement)muRate.divide(this.yawRate)));
        if (FastMath.abs(realBeta).getReal() < aNoon.getReal()) {
            CalculusFieldUnivariateFunction f = yawEnd -> {
                CalculusFieldElement delta = (CalculusFieldElement)((CalculusFieldElement)muRate.multiply((FieldElement)yawEnd)).divide(this.yawRate);
                return (CalculusFieldElement)yawEnd.subtract((FieldElement)((CalculusFieldElement)FastMath.abs((CalculusFieldElement)((CalculusFieldElement)context.computePhi((CalculusFieldElement)realBeta, delta).subtract((FieldElement)context.computePhi((CalculusFieldElement)realBeta, (CalculusFieldElement)delta.negate())))).multiply(0.5)));
            };
            CalculusFieldElement[] bracket = UnivariateSolverUtils.bracket((CalculusFieldUnivariateFunction)f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(YAW_END_ZERO)), (CalculusFieldElement)((CalculusFieldElement)field.getZero()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).getPi()));
            CalculusFieldElement yawEnd2 = new FieldBracketingNthOrderBrentSolver((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-14), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-8), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(1.0E-15), 5).solve(50, f, bracket[0], bracket[1], AllowedSolution.ANY_SIDE);
            aNoon = (CalculusFieldElement)((CalculusFieldElement)muRate.multiply((FieldElement)yawEnd2)).divide(this.yawRate);
        }
        double cNoon = FastMath.cos((double)aNoon.getReal());
        double cNight = FastMath.cos((double)aNight.getReal());
        if (context.setUpTurnRegion(cNight, cNoon)) {
            context.setHalfSpan(context.inSunSide() ? aNoon : context.inOrbitPlaneAbsoluteAngle((CalculusFieldElement)aNight.subtract((FieldElement)((CalculusFieldElement)aNight.getPi()))), 0.0);
            if (context.inTurnTimeRange()) {
                CalculusFieldElement linearPhi;
                CalculusFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((CalculusFieldElement)beta);
                T dtStart = context.timeSinceTurnStart();
                T phiEnd = context.getYawEnd((CalculusFieldElement)beta);
                if (context.inSunSide()) {
                    phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(-FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                    linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                } else {
                    phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                    linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                    if (phiEnd.getReal() / linearPhi.getReal() < 0.0 || phiEnd.getReal() / linearPhi.getReal() > 1.0) {
                        return context.turnCorrectedAttitude((CalculusFieldElement)phiEnd, (CalculusFieldElement)field.getZero());
                    }
                }
                return context.turnCorrectedAttitude(linearPhi, phiDot);
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

