/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class Galileo
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_RATE = FastMath.toRadians((double)0.203);
    private static final double BETA_X = FastMath.toRadians((double)15.0);
    private static final double COS_NOON = FastMath.cos((double)BETA_X);
    private static final double COS_NIGHT = -COS_NOON;
    private static final double END_MARGIN = 0.0;
    private final double yawRate;

    public Galileo(double yawRate, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double beta0 = FastMath.atan((double)(context.getMuRate() / this.yawRate));
        if (FastMath.abs((double)context.betaD2().getValue()) < beta0 && context.setUpTurnRegion(COS_NIGHT, COS_NOON)) {
            context.setHalfSpan(context.inSunSide() ? BETA_X : context.inOrbitPlaneAbsoluteAngle(BETA_X), 0.0);
            if (context.inTurnTimeRange()) {
                UnivariateDerivative2 beta = context.betaD2();
                FieldSinCos scBeta = FastMath.sinCos((CalculusFieldElement)beta);
                UnivariateDerivative2 cosBeta = (UnivariateDerivative2)scBeta.cos();
                UnivariateDerivative2 sinBeta = (UnivariateDerivative2)scBeta.sin();
                double sinY = FastMath.copySign((double)FastMath.sin((double)beta0), (double)context.getSecuredBeta());
                UnivariateDerivative2 sd = ((UnivariateDerivative2)FastMath.sin((CalculusFieldElement)context.getDeltaDS())).multiply(FastMath.copySign((double)1.0, (double)(-context.getSVBcos() * context.getDeltaDS().getPartialDerivative(new int[]{1}))));
                UnivariateDerivative2 c = sd.multiply(cosBeta);
                UnivariateDerivative2 shy = ((UnivariateDerivative2)sinBeta.negate().subtract(sinY)).add(((UnivariateDerivative2)sinBeta.subtract(sinY)).multiply(c.abs().multiply(c.getPi().divide(FastMath.sin((double)BETA_X))).cos())).multiply(0.5);
                UnivariateDerivative2 phi = (UnivariateDerivative2)FastMath.atan2((CalculusFieldElement)shy, (CalculusFieldElement)c);
                return context.turnCorrectedAttitude(phi);
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends CalculusFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        double beta0 = FastMath.atan((double)(context.getMuRate().getReal() / this.yawRate));
        if (FastMath.abs(context.beta(context.getDate())).getReal() < beta0 && context.setUpTurnRegion(COS_NIGHT, COS_NOON)) {
            Field<T> field = context.getDate().getField();
            CalculusFieldElement betaX = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(BETA_X);
            context.setHalfSpan(context.inSunSide() ? betaX : context.inOrbitPlaneAbsoluteAngle(betaX), 0.0);
            if (context.inTurnTimeRange()) {
                FieldUnivariateDerivative2<T> beta = context.betaD2();
                FieldSinCos scBeta = FastMath.sinCos(beta);
                FieldUnivariateDerivative2 cosBeta = (FieldUnivariateDerivative2)scBeta.cos();
                FieldUnivariateDerivative2 sinBeta = (FieldUnivariateDerivative2)scBeta.sin();
                CalculusFieldElement sinY = (CalculusFieldElement)FastMath.sin((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(beta0))).copySign(context.getSecuredBeta());
                FieldUnivariateDerivative2 sd = ((FieldUnivariateDerivative2)FastMath.sin(context.getDeltaDS())).multiply(FastMath.copySign((double)1.0, (double)(-context.getSVBcos().getReal() * context.getDeltaDS().getPartialDerivative(new int[]{1}).getReal())));
                FieldUnivariateDerivative2 c = sd.multiply(cosBeta);
                FieldUnivariateDerivative2 shy = ((FieldUnivariateDerivative2)sinBeta.negate().subtract(sinY)).add(((FieldUnivariateDerivative2)sinBeta.subtract(sinY)).multiply(c.abs().multiply(c.getPi().divide(FastMath.sin((double)BETA_X))).cos())).multiply(0.5);
                FieldUnivariateDerivative2 phi = (FieldUnivariateDerivative2)FastMath.atan2((CalculusFieldElement)shy, (CalculusFieldElement)c);
                return context.turnCorrectedAttitude(phi);
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

