/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class GPSBlockIIF
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_RATE = FastMath.toRadians((double)0.11);
    public static final double DEFAULT_YAW_BIAS = FastMath.toRadians((double)-0.7);
    private static final double NIGHT_TURN_LIMIT = FastMath.toRadians((double)166.75);
    private static final double END_MARGIN = 1800.0;
    private final double yawRate;
    private final double yawBias;

    public GPSBlockIIF(double yawRate, double yawBias, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
        this.yawBias = yawBias;
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double aNoon = FastMath.atan((double)(context.getMuRate() / this.yawRate));
        double aNight = NIGHT_TURN_LIMIT;
        double cNoon = FastMath.cos((double)aNoon);
        double cNight = FastMath.cos((double)aNight);
        if (context.setUpTurnRegion(cNight, cNoon)) {
            double absBeta = FastMath.abs((double)context.beta(context.getDate()));
            context.setHalfSpan(context.inSunSide() ? absBeta * FastMath.sqrt((double)(aNoon / absBeta - 1.0)) : context.inOrbitPlaneAbsoluteAngle(aNight - Math.PI), 1800.0);
            if (context.inTurnTimeRange()) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart();
                if (context.inSunSide()) {
                    if (beta > this.yawBias && beta < 0.0) {
                        phiDot = FastMath.copySign((double)this.yawRate, (double)beta);
                        linearPhi = phiStart + phiDot * dtStart;
                    } else {
                        phiDot = -FastMath.copySign((double)this.yawRate, (double)beta);
                        linearPhi = phiStart + phiDot * dtStart;
                    }
                } else {
                    phiDot = context.yawRate(beta);
                    linearPhi = phiStart + phiDot * dtStart;
                }
                if (context.linearModelStillActive(linearPhi, phiDot)) {
                    return context.turnCorrectedAttitude(linearPhi, phiDot);
                }
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends CalculusFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        CalculusFieldElement aNoon = FastMath.atan((CalculusFieldElement)((CalculusFieldElement)context.getMuRate().divide(this.yawRate)));
        CalculusFieldElement aNight = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(NIGHT_TURN_LIMIT);
        double cNoon = FastMath.cos((double)aNoon.getReal());
        double cNight = FastMath.cos((double)aNight.getReal());
        if (context.setUpTurnRegion(cNight, cNoon)) {
            CalculusFieldElement absBeta = FastMath.abs(context.beta(context.getDate()));
            context.setHalfSpan(context.inSunSide() ? (CalculusFieldElement)absBeta.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aNoon.divide((FieldElement)absBeta)).subtract(1.0)))) : context.inOrbitPlaneAbsoluteAngle((CalculusFieldElement)aNight.subtract((FieldElement)((CalculusFieldElement)aNoon.getPi()))), 1800.0);
            if (context.inTurnTimeRange()) {
                CalculusFieldElement linearPhi;
                Object phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((CalculusFieldElement)beta);
                T dtStart = context.timeSinceTurnStart();
                if (context.inSunSide()) {
                    if (beta.getReal() > this.yawBias && beta.getReal() < 0.0) {
                        phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                        linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                    } else {
                        phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(-FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                        linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                    }
                } else {
                    phiDot = context.yawRate((CalculusFieldElement)beta);
                    linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                }
                if (context.linearModelStillActive(linearPhi, (CalculusFieldElement)phiDot)) {
                    return context.turnCorrectedAttitude(linearPhi, (CalculusFieldElement)phiDot);
                }
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

