/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.AbstractGNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

public class GPSBlockIIA
extends AbstractGNSSAttitudeProvider {
    public static final double DEFAULT_YAW_BIAS = FastMath.toRadians((double)0.5);
    private static final double NIGHT_TURN_LIMIT = FastMath.toRadians((double)166.75);
    private static final double END_MARGIN = 1800.0;
    private static final double[] DEFAULT_YAW_RATES = new double[]{Double.NaN, FastMath.toRadians((double)0.1211), FastMath.toRadians((double)0.1339), FastMath.toRadians((double)0.123), FastMath.toRadians((double)0.1233), FastMath.toRadians((double)0.118), FastMath.toRadians((double)0.1266), FastMath.toRadians((double)0.1269), FastMath.toRadians((double)0.1033), FastMath.toRadians((double)0.1278), FastMath.toRadians((double)0.0978), FastMath.toRadians((double)0.2), FastMath.toRadians((double)0.199), FastMath.toRadians((double)0.2), FastMath.toRadians((double)0.0815), FastMath.toRadians((double)0.1303), FastMath.toRadians((double)0.0838), FastMath.toRadians((double)0.1401), FastMath.toRadians((double)0.1069), FastMath.toRadians((double)0.098), FastMath.toRadians((double)0.103), FastMath.toRadians((double)0.1366), FastMath.toRadians((double)0.1025), FastMath.toRadians((double)0.114), FastMath.toRadians((double)0.1089), FastMath.toRadians((double)0.1001), FastMath.toRadians((double)0.1227), FastMath.toRadians((double)0.1194), FastMath.toRadians((double)0.126), FastMath.toRadians((double)0.1228), FastMath.toRadians((double)0.1165), FastMath.toRadians((double)0.0969), FastMath.toRadians((double)0.114)};
    private final double yawRate;
    private final double yawBias;

    public GPSBlockIIA(double yawRate, double yawBias, AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        super(validityStart, validityEnd, sun, inertialFrame);
        this.yawRate = yawRate;
        this.yawBias = yawBias;
    }

    public static double getDefaultYawRate(int prnNumber) {
        return DEFAULT_YAW_RATES[prnNumber];
    }

    @Override
    protected TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext context) {
        double aNoon = FastMath.atan((double)(context.getMuRate() / this.yawRate));
        double aNight = NIGHT_TURN_LIMIT;
        double cNoon = FastMath.cos((double)aNoon);
        double cNight = FastMath.cos((double)aNight);
        if (context.setUpTurnRegion(cNight, cNoon)) {
            double absBeta = FastMath.abs((double)context.beta(context.getDate()));
            context.setHalfSpan(context.inSunSide() ? absBeta * FastMath.sqrt((double)(aNoon / absBeta - 1.0)) : context.inOrbitPlaneAbsoluteAngle(aNight - Math.PI), 1800.0);
            if (context.inTurnTimeRange()) {
                double linearPhi;
                double phiDot;
                double beta = context.getSecuredBeta();
                double phiStart = context.getYawStart(beta);
                double dtStart = context.timeSinceTurnStart();
                if (context.inSunSide()) {
                    if (beta > 0.0 && beta < this.yawBias) {
                        phiDot = FastMath.copySign((double)this.yawRate, (double)beta);
                        linearPhi = phiStart + phiDot * dtStart;
                    } else {
                        phiDot = -FastMath.copySign((double)this.yawRate, (double)beta);
                        linearPhi = phiStart + phiDot * dtStart;
                    }
                } else {
                    phiDot = this.yawRate;
                    linearPhi = phiStart + phiDot * dtStart;
                }
                if (context.linearModelStillActive(linearPhi, phiDot)) {
                    return context.turnCorrectedAttitude(linearPhi, phiDot);
                }
            }
        }
        return context.nominalYaw(context.getDate());
    }

    @Override
    protected <T extends CalculusFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> context) {
        Field<T> field = context.getDate().getField();
        CalculusFieldElement aNoon = FastMath.atan((CalculusFieldElement)((CalculusFieldElement)context.getMuRate().divide(this.yawRate)));
        CalculusFieldElement aNight = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(NIGHT_TURN_LIMIT);
        double cNoon = FastMath.cos((double)aNoon.getReal());
        double cNight = FastMath.cos((double)aNight.getReal());
        if (context.setUpTurnRegion(cNight, cNoon)) {
            CalculusFieldElement absBeta = FastMath.abs(context.beta(context.getDate()));
            context.setHalfSpan(context.inSunSide() ? (CalculusFieldElement)absBeta.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aNoon.divide((FieldElement)absBeta)).subtract(1.0)))) : context.inOrbitPlaneAbsoluteAngle((CalculusFieldElement)aNight.subtract((FieldElement)((CalculusFieldElement)aNoon.getPi()))), 1800.0);
            if (context.inTurnTimeRange()) {
                CalculusFieldElement linearPhi;
                CalculusFieldElement phiDot;
                T beta = context.getSecuredBeta();
                T phiStart = context.getYawStart((CalculusFieldElement)beta);
                T dtStart = context.timeSinceTurnStart();
                if (context.inSunSide()) {
                    if (beta.getReal() > 0.0 && beta.getReal() < this.yawBias) {
                        phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                        linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                    } else {
                        phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(-FastMath.copySign((double)this.yawRate, (double)beta.getReal()));
                        linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                    }
                } else {
                    phiDot = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(this.yawRate);
                    linearPhi = (CalculusFieldElement)phiStart.add((FieldElement)((CalculusFieldElement)phiDot.multiply(dtStart)));
                }
                if (context.linearModelStillActive(linearPhi, phiDot)) {
                    return context.turnCorrectedAttitude(linearPhi, phiDot);
                }
            }
        }
        return context.nominalYaw(context.getDate());
    }
}

