/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.gnss.attitude.FieldTurnSpan;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

class GNSSFieldAttitudeContext<T extends CalculusFieldElement<T>>
implements FieldTimeStamped<T> {
    private static final PVCoordinates PLUS_Y_PV = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates MINUS_Z_PV = new PVCoordinates(Vector3D.MINUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private static final double BETA_SIGN_CHANGE_PROTECTION = FastMath.toRadians((double)0.07);
    private final FieldPVCoordinates<T> plusY;
    private final FieldPVCoordinates<T> minusZ;
    private final AbsoluteDate dateDouble;
    private final FieldAbsoluteDate<T> date;
    private final ExtendedPVCoordinatesProvider sun;
    private final FieldPVCoordinatesProvider<T> pvProv;
    private final TimeStampedFieldPVCoordinates<T> svPV;
    private final TimeStampedFieldPVCoordinates<T> sunPV;
    private final Frame inertialFrame;
    private final T svbCos;
    private final boolean morning;
    private final FieldUnivariateDerivative2<T> delta;
    private final FieldUnivariateDerivative2<T> beta;
    private T muRate;
    private double cNight;
    private double cNoon;
    private FieldTurnSpan<T> turnSpan;

    GNSSFieldAttitudeContext(FieldAbsoluteDate<T> date, ExtendedPVCoordinatesProvider sun, FieldPVCoordinatesProvider<T> pvProv, Frame inertialFrame, FieldTurnSpan<T> turnSpan) {
        Field<T> field = date.getField();
        this.plusY = new FieldPVCoordinates<Field<T>>(field, PLUS_Y_PV);
        this.minusZ = new FieldPVCoordinates<Field<T>>(field, MINUS_Z_PV);
        this.dateDouble = date.toAbsoluteDate();
        this.date = date;
        this.sun = sun;
        this.pvProv = pvProv;
        this.inertialFrame = inertialFrame;
        this.sunPV = sun.getPVCoordinates(date, inertialFrame);
        this.svPV = pvProv.getPVCoordinates(date, inertialFrame);
        this.morning = Vector3D.dotProduct((Vector3D)this.svPV.getVelocity().toVector3D(), (Vector3D)this.sunPV.getPosition().toVector3D()) >= 0.0;
        this.muRate = this.svPV.getAngularVelocity().getNorm();
        this.turnSpan = turnSpan;
        FieldPVCoordinates sunPVD2 = this.sunPV.toUnivariateDerivative2PV();
        FieldPVCoordinates svPVD2 = this.svPV.toUnivariateDerivative2PV();
        FieldUnivariateDerivative2 svbCosD2 = ((FieldUnivariateDerivative2)FieldVector3D.dotProduct(sunPVD2.getPosition(), svPVD2.getPosition())).divide(((FieldUnivariateDerivative2)sunPVD2.getPosition().getNorm()).multiply((FieldUnivariateDerivative2)svPVD2.getPosition().getNorm()));
        this.svbCos = svbCosD2.getValue();
        this.beta = ((FieldUnivariateDerivative2)FieldVector3D.angle(sunPVD2.getPosition(), svPVD2.getMomentum())).negate().add(1.5707963267948966);
        FieldUnivariateDerivative2 absDelta = this.svbCos.getReal() <= 0.0 ? (FieldUnivariateDerivative2)FastMath.acos((CalculusFieldElement)svbCosD2.negate().divide((FieldUnivariateDerivative2)FastMath.cos(this.beta))) : (FieldUnivariateDerivative2)FastMath.acos((CalculusFieldElement)svbCosD2.divide((FieldUnivariateDerivative2)FastMath.cos(this.beta)));
        this.delta = absDelta.copySign((CalculusFieldElement)absDelta.getPartialDerivative(new int[]{1}).negate());
    }

    public TimeStampedFieldAngularCoordinates<T> nominalYaw(FieldAbsoluteDate<T> d) {
        TimeStampedFieldPVCoordinates<T> pv = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return new TimeStampedFieldAngularCoordinates<T>(d, pv.normalize(), this.sun.getPVCoordinates(d, this.inertialFrame).crossProduct(pv).normalize(), this.minusZ, this.plusY, 1.0E-9);
    }

    public T beta(FieldAbsoluteDate<T> d) {
        TimeStampedFieldPVCoordinates<T> pv = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return (T)((CalculusFieldElement)((CalculusFieldElement)FieldVector3D.angle(this.sun.getPosition(d, this.inertialFrame), pv.getMomentum()).negate()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.svPV.getPosition().getX().getPi()).multiply(0.5))));
    }

    public FieldUnivariateDerivative2<T> betaD2() {
        return this.beta;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    public FieldTurnSpan<T> getTurnSpan() {
        return this.turnSpan;
    }

    public T getSVBcos() {
        return this.svbCos;
    }

    public T getSecuredBeta() {
        return (T)(FastMath.abs((double)this.beta.getValue().getReal()) < BETA_SIGN_CHANGE_PROTECTION ? this.beta(this.turnSpan.getTurnStartDate()) : this.beta.getValue());
    }

    public boolean linearModelStillActive(T linearPhi, T phiDot) {
        double dtMax;
        AbsoluteDate absDate = this.date.toAbsoluteDate();
        double dt0 = this.turnSpan.getTurnEndDate().durationFrom(this.date).getReal();
        UnivariateFunction yawReached = dt -> {
            AbsoluteDate t = absDate.shiftedBy(dt);
            Vector3D pSun = this.sun.getPosition(t, this.inertialFrame);
            PVCoordinates pv = this.pvProv.getPVCoordinates((FieldAbsoluteDate<T>)this.date.shiftedBy(dt), this.inertialFrame).toPVCoordinates();
            Vector3D pSat = pv.getPosition();
            Vector3D targetX = (Vector3D)Vector3D.crossProduct((Vector3D)pSat, (Vector3D)Vector3D.crossProduct((Vector3D)pSun, (Vector3D)pSat)).normalize();
            double phi = linearPhi.getReal() + dt * phiDot.getReal();
            SinCos sc = FastMath.sinCos((double)phi);
            Vector3D pU = (Vector3D)pv.getPosition().normalize();
            Vector3D mU = (Vector3D)pv.getMomentum().normalize();
            Vector3D omega = new Vector3D(-phiDot.getReal(), pU);
            Vector3D currentX = new Vector3D(-sc.sin(), mU, -sc.cos(), Vector3D.crossProduct((Vector3D)pU, (Vector3D)mU));
            Vector3D currentXDot = Vector3D.crossProduct((Vector3D)omega, (Vector3D)currentX);
            return Vector3D.dotProduct((Vector3D)targetX, (Vector3D)currentXDot);
        };
        double fullTurn = Math.PI * 2 / FastMath.abs((double)phiDot.getReal());
        double dtMin = FastMath.min((double)this.turnSpan.getTurnStartDate().durationFrom(this.date).getReal(), (double)(dt0 - 60.0));
        double[] bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)dt0, (double)dtMin, (double)(dtMax = FastMath.max((double)(dtMin + fullTurn), (double)(dt0 + 60.0))), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        if (yawReached.value(bracket[0]) <= 0.0) {
            bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)(0.5 * (bracket[0] + bracket[1] + fullTurn)), (double)bracket[1], (double)(bracket[1] + fullTurn), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        }
        double dt2 = new BracketingNthOrderBrentSolver(0.001, 5).solve(100, yawReached, bracket[0], bracket[1]);
        this.turnSpan.updateEnd((FieldAbsoluteDate<T>)this.date.shiftedBy(dt2), absDate);
        return dt2 > 0.0;
    }

    public boolean setUpTurnRegion(double cosNight, double cosNoon) {
        this.cNight = cosNight;
        this.cNoon = cosNoon;
        if (this.svbCos.getReal() < this.cNight || this.svbCos.getReal() > this.cNoon) {
            return true;
        }
        return this.inTurnTimeRange();
    }

    public FieldUnivariateDerivative2<T> getDeltaDS() {
        return this.delta;
    }

    public T getOrbitAngleSinceMidnight() {
        CalculusFieldElement absAngle = this.inOrbitPlaneAbsoluteAngle((CalculusFieldElement)((CalculusFieldElement)FastMath.acos(this.svbCos).negate()).add((FieldElement)((CalculusFieldElement)this.svbCos.getPi())));
        return (T)(this.morning ? absAngle : (CalculusFieldElement)absAngle.negate());
    }

    public boolean inSunSide() {
        return this.svbCos.getReal() > 0.0;
    }

    public T getYawStart(T sunBeta) {
        CalculusFieldElement halfSpan = (CalculusFieldElement)((CalculusFieldElement)this.turnSpan.getTurnDuration().multiply(this.muRate)).multiply(0.5);
        return (T)this.computePhi(sunBeta, FastMath.copySign((CalculusFieldElement)halfSpan, this.svbCos));
    }

    public T getYawEnd(T sunBeta) {
        CalculusFieldElement halfSpan = (CalculusFieldElement)((CalculusFieldElement)this.turnSpan.getTurnDuration().multiply(this.muRate)).multiply(0.5);
        return (T)this.computePhi(sunBeta, FastMath.copySign((CalculusFieldElement)halfSpan, (CalculusFieldElement)((CalculusFieldElement)this.svbCos.negate())));
    }

    public T yawRate(T sunBeta) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.getYawEnd(sunBeta).subtract(this.getYawStart(sunBeta))).divide(this.turnSpan.getTurnDuration()));
    }

    public T getMuRate() {
        return this.muRate;
    }

    public T inOrbitPlaneAbsoluteAngle(T angle) {
        return (T)FastMath.acos((CalculusFieldElement)((CalculusFieldElement)FastMath.cos(angle).divide((FieldElement)FastMath.cos(this.beta(this.getDate())))));
    }

    public T computePhi(T sunBeta, T inOrbitPlaneAngle) {
        return (T)FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)FastMath.tan(sunBeta).negate()), (CalculusFieldElement)FastMath.sin(inOrbitPlaneAngle));
    }

    public void setHalfSpan(T halfSpan, double endMargin) {
        FieldTimeShiftable start = this.date.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.delta.getValue().subtract(halfSpan)).divide(this.muRate));
        FieldTimeShiftable end = this.date.shiftedBy((CalculusFieldElement)((CalculusFieldElement)this.delta.getValue().add(halfSpan)).divide(this.muRate));
        AbsoluteDate estimationDate = this.getDate().toAbsoluteDate();
        if (this.turnSpan == null) {
            this.turnSpan = new FieldTurnSpan(start, end, estimationDate, endMargin);
        } else {
            this.turnSpan.updateStart((FieldAbsoluteDate<T>)start, estimationDate);
            this.turnSpan.updateEnd((FieldAbsoluteDate<T>)end, estimationDate);
        }
    }

    public boolean inTurnTimeRange() {
        return this.turnSpan != null && this.turnSpan.inTurnTimeRange(this.dateDouble);
    }

    public T timeSinceTurnStart() {
        return this.getDate().durationFrom(this.turnSpan.getTurnStartDate());
    }

    public TimeStampedFieldAngularCoordinates<T> turnCorrectedAttitude(T yaw, T yawDot) {
        return this.turnCorrectedAttitude(new FieldUnivariateDerivative2(yaw, yawDot, (CalculusFieldElement)yaw.getField().getZero()));
    }

    public TimeStampedFieldAngularCoordinates<T> turnCorrectedAttitude(FieldUnivariateDerivative2<T> yaw) {
        FieldVector3D p = this.svPV.getPosition();
        FieldVector3D v = this.svPV.getVelocity();
        FieldVector3D a = this.svPV.getAcceleration();
        CalculusFieldElement r2 = p.getNormSq();
        CalculusFieldElement r = FastMath.sqrt((CalculusFieldElement)r2);
        FieldVector3D keplerianJerk = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)FieldVector3D.dotProduct(p, v).multiply(-3)).divide((FieldElement)r2), a, (CalculusFieldElement)((CalculusFieldElement)a.getNorm().negate()).divide((FieldElement)r), v);
        FieldPVCoordinates velocity = new FieldPVCoordinates(v, a, keplerianJerk);
        FieldPVCoordinates momentum = this.svPV.crossProduct(velocity);
        FieldSinCos sc = FastMath.sinCos(yaw);
        FieldUnivariateDerivative2 c = ((FieldUnivariateDerivative2)sc.cos()).negate();
        FieldUnivariateDerivative2 s = ((FieldUnivariateDerivative2)sc.sin()).negate();
        CalculusFieldElement z = (CalculusFieldElement)yaw.getValueField().getZero();
        FieldVector3D m0 = new FieldVector3D(s.getValue(), c.getValue(), z);
        FieldVector3D m1 = new FieldVector3D(s.getPartialDerivative(new int[]{1}), c.getPartialDerivative(new int[]{1}), z);
        FieldVector3D m2 = new FieldVector3D(s.getPartialDerivative(new int[]{2}), c.getPartialDerivative(new int[]{2}), z);
        return new TimeStampedFieldAngularCoordinates<T>(this.date, this.svPV.normalize(), momentum.normalize(), this.minusZ, new FieldPVCoordinates(m0, m1, m2), 1.0E-9);
    }

    public TimeStampedFieldAngularCoordinates<T> orbitNormalYaw() {
        FieldTransform<T> t = LOFType.LVLH_CCSDS.transformFromInertial(this.date, this.pvProv.getPVCoordinates(this.date, this.inertialFrame));
        return new TimeStampedFieldAngularCoordinates<T>(this.date, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

