/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.analysis.solvers.UnivariateSolverUtils;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.gnss.attitude.TurnSpan;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

class GNSSAttitudeContext
implements TimeStamped {
    private static final PVCoordinates PLUS_Y_PV = new PVCoordinates(Vector3D.PLUS_J, Vector3D.ZERO, Vector3D.ZERO);
    private static final PVCoordinates MINUS_Z_PV = new PVCoordinates(Vector3D.MINUS_K, Vector3D.ZERO, Vector3D.ZERO);
    private static final double BETA_SIGN_CHANGE_PROTECTION = FastMath.toRadians((double)0.07);
    private final AbsoluteDate date;
    private final ExtendedPVCoordinatesProvider sun;
    private final PVCoordinatesProvider pvProv;
    private final TimeStampedPVCoordinates svPV;
    private final TimeStampedPVCoordinates sunPV;
    private final Frame inertialFrame;
    private final double svbCos;
    private final boolean morning;
    private UnivariateDerivative2 delta;
    private UnivariateDerivative2 beta;
    private double muRate;
    private double cNight;
    private double cNoon;
    private TurnSpan turnSpan;

    GNSSAttitudeContext(AbsoluteDate date, ExtendedPVCoordinatesProvider sun, PVCoordinatesProvider pvProv, Frame inertialFrame, TurnSpan turnSpan) {
        this.date = date;
        this.sun = sun;
        this.pvProv = pvProv;
        this.inertialFrame = inertialFrame;
        this.sunPV = sun.getPVCoordinates(date, inertialFrame);
        this.svPV = pvProv.getPVCoordinates(date, inertialFrame);
        this.morning = Vector3D.dotProduct((Vector3D)this.svPV.getVelocity(), (Vector3D)this.sunPV.getPosition()) >= 0.0;
        this.muRate = this.svPV.getAngularVelocity().getNorm();
        this.turnSpan = turnSpan;
        FieldPVCoordinates<UnivariateDerivative2> sunPVD2 = this.sunPV.toUnivariateDerivative2PV();
        FieldPVCoordinates<UnivariateDerivative2> svPVD2 = this.svPV.toUnivariateDerivative2PV();
        UnivariateDerivative2 svbCosD2 = ((UnivariateDerivative2)FieldVector3D.dotProduct(sunPVD2.getPosition(), svPVD2.getPosition())).divide(((UnivariateDerivative2)sunPVD2.getPosition().getNorm()).multiply((UnivariateDerivative2)svPVD2.getPosition().getNorm()));
        this.svbCos = svbCosD2.getValue();
        this.beta = (UnivariateDerivative2)((UnivariateDerivative2)FieldVector3D.angle(sunPVD2.getPosition(), svPVD2.getMomentum())).negate().add(1.5707963267948966);
        UnivariateDerivative2 absDelta = this.svbCos <= 0.0 ? (UnivariateDerivative2)FastMath.acos((CalculusFieldElement)svbCosD2.negate().divide((UnivariateDerivative2)FastMath.cos((CalculusFieldElement)this.beta))) : (UnivariateDerivative2)FastMath.acos((CalculusFieldElement)svbCosD2.divide((UnivariateDerivative2)FastMath.cos((CalculusFieldElement)this.beta)));
        this.delta = (UnivariateDerivative2)FastMath.copySign((CalculusFieldElement)absDelta, (double)(-absDelta.getPartialDerivative(new int[]{1})));
    }

    public TimeStampedAngularCoordinates nominalYaw(AbsoluteDate d) {
        TimeStampedPVCoordinates pv = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return new TimeStampedAngularCoordinates(d, pv.normalize(), PVCoordinates.crossProduct(this.sun.getPVCoordinates(d, this.inertialFrame), pv).normalize(), MINUS_Z_PV, PLUS_Y_PV, 1.0E-9);
    }

    public double beta(AbsoluteDate d) {
        TimeStampedPVCoordinates pv = this.pvProv.getPVCoordinates(d, this.inertialFrame);
        return 1.5707963267948966 - Vector3D.angle((Vector3D)this.sun.getPosition(d, this.inertialFrame), (Vector3D)pv.getMomentum());
    }

    public UnivariateDerivative2 betaD2() {
        return this.beta;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    public TurnSpan getTurnSpan() {
        return this.turnSpan;
    }

    public double getSVBcos() {
        return this.svbCos;
    }

    public double getSecuredBeta() {
        return FastMath.abs((double)this.beta.getValue()) < BETA_SIGN_CHANGE_PROTECTION ? this.beta(this.turnSpan.getTurnStartDate()) : this.beta.getValue();
    }

    public boolean linearModelStillActive(double linearPhi, double phiDot) {
        double dtMax;
        double dt0 = this.turnSpan.getTurnEndDate().durationFrom(this.date);
        UnivariateFunction yawReached = dt -> {
            AbsoluteDate t = this.date.shiftedBy(dt);
            Vector3D pSun = this.sun.getPosition(t, this.inertialFrame);
            TimeStampedPVCoordinates pv = this.pvProv.getPVCoordinates(t, this.inertialFrame);
            Vector3D pSat = pv.getPosition();
            Vector3D targetX = (Vector3D)Vector3D.crossProduct((Vector3D)pSat, (Vector3D)Vector3D.crossProduct((Vector3D)pSun, (Vector3D)pSat)).normalize();
            double phi = linearPhi + dt * phiDot;
            SinCos sc = FastMath.sinCos((double)phi);
            Vector3D pU = (Vector3D)pv.getPosition().normalize();
            Vector3D mU = (Vector3D)pv.getMomentum().normalize();
            Vector3D omega = new Vector3D(-phiDot, pU);
            Vector3D currentX = new Vector3D(-sc.sin(), mU, -sc.cos(), Vector3D.crossProduct((Vector3D)pU, (Vector3D)mU));
            Vector3D currentXDot = Vector3D.crossProduct((Vector3D)omega, (Vector3D)currentX);
            return Vector3D.dotProduct((Vector3D)targetX, (Vector3D)currentXDot);
        };
        double fullTurn = Math.PI * 2 / FastMath.abs((double)phiDot);
        double dtMin = FastMath.min((double)this.turnSpan.getTurnStartDate().durationFrom(this.date), (double)(dt0 - 60.0));
        double[] bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)dt0, (double)dtMin, (double)(dtMax = FastMath.max((double)(dtMin + fullTurn), (double)(dt0 + 60.0))), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        if (yawReached.value(bracket[0]) <= 0.0) {
            bracket = UnivariateSolverUtils.bracket((UnivariateFunction)yawReached, (double)(0.5 * (bracket[0] + bracket[1] + fullTurn)), (double)bracket[1], (double)(bracket[1] + fullTurn), (double)(fullTurn / 100.0), (double)1.0, (int)100);
        }
        double dt2 = new BracketingNthOrderBrentSolver(0.001, 5).solve(100, yawReached, bracket[0], bracket[1]);
        this.turnSpan.updateEnd(this.date.shiftedBy(dt2), this.date);
        return dt2 > 0.0;
    }

    public boolean setUpTurnRegion(double cosNight, double cosNoon) {
        this.cNight = cosNight;
        this.cNoon = cosNoon;
        if (this.svbCos < this.cNight || this.svbCos > this.cNoon) {
            return true;
        }
        return this.inTurnTimeRange();
    }

    public UnivariateDerivative2 getDeltaDS() {
        return this.delta;
    }

    public double getOrbitAngleSinceMidnight() {
        double absAngle = this.inOrbitPlaneAbsoluteAngle(Math.PI - FastMath.acos((double)this.svbCos));
        return this.morning ? absAngle : -absAngle;
    }

    public boolean inSunSide() {
        return this.svbCos > 0.0;
    }

    public double getYawStart(double sunBeta) {
        double halfSpan = 0.5 * this.turnSpan.getTurnDuration() * this.muRate;
        return this.computePhi(sunBeta, FastMath.copySign((double)halfSpan, (double)this.svbCos));
    }

    public double getYawEnd(double sunBeta) {
        double halfSpan = 0.5 * this.turnSpan.getTurnDuration() * this.muRate;
        return this.computePhi(sunBeta, FastMath.copySign((double)halfSpan, (double)(-this.svbCos)));
    }

    public double yawRate(double sunBeta) {
        return (this.getYawEnd(sunBeta) - this.getYawStart(sunBeta)) / this.turnSpan.getTurnDuration();
    }

    public double getMuRate() {
        return this.muRate;
    }

    public double inOrbitPlaneAbsoluteAngle(double angle) {
        return FastMath.acos((double)(FastMath.cos((double)angle) / FastMath.cos((double)this.beta(this.getDate()))));
    }

    public double computePhi(double sunBeta, double inOrbitPlaneAngle) {
        return FastMath.atan2((double)(-FastMath.tan((double)sunBeta)), (double)FastMath.sin((double)inOrbitPlaneAngle));
    }

    public void setHalfSpan(double halfSpan, double endMargin) {
        AbsoluteDate start = this.date.shiftedBy((this.delta.getValue() - halfSpan) / this.muRate);
        AbsoluteDate end = this.date.shiftedBy((this.delta.getValue() + halfSpan) / this.muRate);
        AbsoluteDate estimationDate = this.getDate();
        if (this.turnSpan == null) {
            this.turnSpan = new TurnSpan(start, end, estimationDate, endMargin);
        } else {
            this.turnSpan.updateStart(start, estimationDate);
            this.turnSpan.updateEnd(end, estimationDate);
        }
    }

    public boolean inTurnTimeRange() {
        return this.turnSpan != null && this.turnSpan.inTurnTimeRange(this.getDate());
    }

    public double timeSinceTurnStart() {
        return this.getDate().durationFrom(this.turnSpan.getTurnStartDate());
    }

    public TimeStampedAngularCoordinates turnCorrectedAttitude(double yaw, double yawDot) {
        return this.turnCorrectedAttitude(new UnivariateDerivative2(yaw, yawDot, 0.0));
    }

    public TimeStampedAngularCoordinates turnCorrectedAttitude(UnivariateDerivative2 yaw) {
        Vector3D p = this.svPV.getPosition();
        Vector3D v = this.svPV.getVelocity();
        Vector3D a = this.svPV.getAcceleration();
        double r2 = p.getNormSq();
        double r = FastMath.sqrt((double)r2);
        Vector3D keplerianJerk = new Vector3D(-3.0 * Vector3D.dotProduct((Vector3D)p, (Vector3D)v) / r2, a, -a.getNorm() / r, v);
        PVCoordinates velocity = new PVCoordinates(v, a, keplerianJerk);
        PVCoordinates momentum = PVCoordinates.crossProduct(this.svPV, velocity);
        FieldSinCos sc = FastMath.sinCos((CalculusFieldElement)yaw);
        UnivariateDerivative2 c = ((UnivariateDerivative2)sc.cos()).negate();
        UnivariateDerivative2 s = ((UnivariateDerivative2)sc.sin()).negate();
        Vector3D m0 = new Vector3D(s.getValue(), c.getValue(), 0.0);
        Vector3D m1 = new Vector3D(s.getPartialDerivative(new int[]{1}), c.getPartialDerivative(new int[]{1}), 0.0);
        Vector3D m2 = new Vector3D(s.getPartialDerivative(new int[]{2}), c.getPartialDerivative(new int[]{2}), 0.0);
        return new TimeStampedAngularCoordinates(this.date, this.svPV.normalize(), momentum.normalize(), MINUS_Z_PV, new PVCoordinates(m0, m1, m2), 1.0E-9);
    }

    public TimeStampedAngularCoordinates orbitNormalYaw() {
        Transform t = LOFType.LVLH_CCSDS.transformFromInertial(this.date, this.pvProv.getPVCoordinates(this.date, this.inertialFrame));
        return new TimeStampedAngularCoordinates(this.date, t.getRotation(), t.getRotationRate(), t.getRotationAcceleration());
    }
}

