/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.frames.Frame;
import org.orekit.gnss.attitude.FieldTurnSpan;
import org.orekit.gnss.attitude.GNSSAttitudeContext;
import org.orekit.gnss.attitude.GNSSAttitudeProvider;
import org.orekit.gnss.attitude.GNSSFieldAttitudeContext;
import org.orekit.gnss.attitude.TurnSpan;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;

abstract class AbstractGNSSAttitudeProvider
implements GNSSAttitudeProvider {
    private final AbsoluteDate validityStart;
    private final AbsoluteDate validityEnd;
    private final ExtendedPVCoordinatesProvider sun;
    private final Frame inertialFrame;
    private final SortedSet<TimeStamped> turns;
    private final transient Map<Field<? extends CalculusFieldElement<?>>, SortedSet<TimeStamped>> fieldTurns;

    protected AbstractGNSSAttitudeProvider(AbsoluteDate validityStart, AbsoluteDate validityEnd, ExtendedPVCoordinatesProvider sun, Frame inertialFrame) {
        this.validityStart = validityStart;
        this.validityEnd = validityEnd;
        this.sun = sun;
        this.inertialFrame = inertialFrame;
        this.turns = new TreeSet<TimeStamped>(new ChronologicalComparator());
        this.fieldTurns = new HashMap();
    }

    @Override
    public AbsoluteDate validityStart() {
        return this.validityStart;
    }

    @Override
    public AbsoluteDate validityEnd() {
        return this.validityEnd;
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) {
        TurnSpan turnSpan = this.getTurnSpan(date);
        GNSSAttitudeContext context = new GNSSAttitudeContext(date, this.sun, pvProv, this.inertialFrame, turnSpan);
        TimeStampedAngularCoordinates corrected = this.correctedYaw(context);
        if (turnSpan == null && context.getTurnSpan() != null) {
            this.turns.add(context.getTurnSpan());
        }
        return new Attitude(this.inertialFrame, corrected).withReferenceFrame(frame);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) {
        FieldTurnSpan<T> turnSpan = this.getTurnSpan(date);
        GNSSFieldAttitudeContext<T> context = new GNSSFieldAttitudeContext<T>(date, this.sun, pvProv, this.inertialFrame, turnSpan);
        TimeStampedFieldAngularCoordinates<T> corrected = this.correctedYaw(context);
        if (turnSpan == null && context.getTurnSpan() != null) {
            this.fieldTurns.get(date.getField()).add(context.getTurnSpan());
        }
        return new FieldAttitude<T>(this.inertialFrame, corrected).withReferenceFrame(frame);
    }

    private TurnSpan getTurnSpan(AbsoluteDate date) {
        TurnSpan ts;
        SortedSet<TimeStamped> after = this.turns.tailSet(date);
        if (!after.isEmpty() && (ts = (TurnSpan)after.first()).inTurnTimeRange(date)) {
            return ts;
        }
        return null;
    }

    private <T extends CalculusFieldElement<T>> FieldTurnSpan<T> getTurnSpan(FieldAbsoluteDate<T> date) {
        FieldTurnSpan ts;
        AbsoluteDate dateDouble;
        SortedSet<TimeStamped> after;
        SortedSet<TimeStamped> sortedSet = this.fieldTurns.get(date.getField());
        if (sortedSet == null) {
            sortedSet = new TreeSet<TimeStamped>(new ChronologicalComparator());
            this.fieldTurns.put(date.getField(), sortedSet);
        }
        if (!(after = sortedSet.tailSet(dateDouble = date.toAbsoluteDate())).isEmpty() && (ts = (FieldTurnSpan)after.first()).inTurnTimeRange(dateDouble)) {
            return ts;
        }
        return null;
    }

    protected ExtendedPVCoordinatesProvider getSun() {
        return this.sun;
    }

    protected Frame getInertialFrame() {
        return this.inertialFrame;
    }

    protected abstract TimeStampedAngularCoordinates correctedYaw(GNSSAttitudeContext var1);

    protected abstract <T extends CalculusFieldElement<T>> TimeStampedFieldAngularCoordinates<T> correctedYaw(GNSSFieldAttitudeContext<T> var1);
}

