/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.antenna;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.gnss.antenna.PhaseCenterVariationFunction;

public class FrequencyPattern {
    public static final FrequencyPattern ZERO_CORRECTION = new FrequencyPattern(Vector3D.ZERO, null);
    private final Vector3D eccentricities;
    private final PhaseCenterVariationFunction phaseCenterVariationFunction;

    public FrequencyPattern(Vector3D eccentricities, PhaseCenterVariationFunction phaseCenterVariationFunction) {
        this.eccentricities = eccentricities;
        this.phaseCenterVariationFunction = phaseCenterVariationFunction;
    }

    public Vector3D getEccentricities() {
        return this.eccentricities;
    }

    public PhaseCenterVariationFunction getPhaseCenterVariationFunction() {
        return this.phaseCenterVariationFunction;
    }

    public double getPhaseCenterVariation(Vector3D direction) {
        if (this.phaseCenterVariationFunction == null) {
            return 0.0;
        }
        return this.phaseCenterVariationFunction.value(1.5707963267948966 - direction.getDelta(), direction.getAlpha());
    }
}

