/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScales;

public enum TimeSystem {
    GPS("GPS", "GP", "G", TimeScales::getGPS),
    GLONASS("GLO", "GL", "R", TimeScales::getGLONASS),
    GALILEO("GAL", "GA", "E", TimeScales::getGST),
    TAI("TAI", null, null, TimeScales::getTAI),
    UTC("UTC", "UT", null, TimeScales::getUTC),
    QZSS("QZS", "QZ", "J", TimeScales::getQZSS),
    BEIDOU("BDT", "BD", "C", TimeScales::getBDT),
    IRNSS("IRN", "IR", "I", TimeScales::getIRNSS),
    SBAS(null, "SB", "S", TimeScales::getUTC),
    GMT("GMT", null, null, TimeScales::getUTC),
    UNKNOWN("LCL", null, null, TimeScales::getGPS);

    private static final Map<String, TimeSystem> KEYS_MAP;
    private static final Map<String, TimeSystem> TLC_MAP;
    private static final Map<String, TimeSystem> OLC_MAP;
    private final String key;
    private final String twoLettersCode;
    private final String oneLetterCode;
    private final Function<TimeScales, TimeScale> timeScaleProvider;

    private TimeSystem(String key, String twoLettersCode, String oneLetterCode, Function<TimeScales, TimeScale> timeScaleProvider) {
        this.key = key;
        this.twoLettersCode = twoLettersCode;
        this.oneLetterCode = oneLetterCode;
        this.timeScaleProvider = timeScaleProvider;
    }

    public String getKey() {
        return this.key;
    }

    public String getTwoLettersCode() {
        return this.twoLettersCode;
    }

    public String getOneLetterCode() {
        return this.oneLetterCode;
    }

    public static TimeSystem parseTimeSystem(String s) throws OrekitIllegalArgumentException {
        TimeSystem timeSystem = KEYS_MAP.get(s);
        if (timeSystem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_TIME_SYSTEM, s);
        }
        return timeSystem;
    }

    public static TimeSystem parseTwoLettersCode(String code) throws OrekitIllegalArgumentException {
        TimeSystem timeSystem = TLC_MAP.get(code);
        if (timeSystem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_TIME_SYSTEM, code);
        }
        return timeSystem;
    }

    public static TimeSystem parseOneLetterCode(String code) throws OrekitIllegalArgumentException {
        TimeSystem timeSystem = OLC_MAP.get(code);
        if (timeSystem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_TIME_SYSTEM, code);
        }
        return timeSystem;
    }

    public TimeScale getTimeScale(TimeScales timeScales) {
        return this.timeScaleProvider.apply(timeScales);
    }

    static {
        KEYS_MAP = new HashMap<String, TimeSystem>();
        TLC_MAP = new HashMap<String, TimeSystem>();
        OLC_MAP = new HashMap<String, TimeSystem>();
        for (TimeSystem timeSystem : TimeSystem.values()) {
            if (timeSystem.key != null) {
                KEYS_MAP.put(timeSystem.key, timeSystem);
            }
            if (timeSystem.twoLettersCode != null) {
                TLC_MAP.put(timeSystem.twoLettersCode, timeSystem);
            }
            if (timeSystem.oneLetterCode == null) continue;
            OLC_MAP.put(timeSystem.oneLetterCode, timeSystem);
        }
    }
}

