/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.ObservationTimeScale;

public enum SatelliteSystem {
    USER_DEFINED_A('A', null),
    USER_DEFINED_B('B', null),
    BEIDOU('C', ObservationTimeScale.BDT),
    USER_DEFINED_D('D', null),
    GALILEO('E', ObservationTimeScale.GAL),
    USER_DEFINED_F('F', null),
    GPS('G', ObservationTimeScale.GPS),
    USER_DEFINED_H('H', null),
    IRNSS('I', ObservationTimeScale.IRN),
    QZSS('J', ObservationTimeScale.QZS),
    USER_DEFINED_K('K', null),
    USER_DEFINED_L('L', null),
    MIXED('M', null),
    USER_DEFINED_N('N', null),
    USER_DEFINED_O('O', null),
    USER_DEFINED_P('P', null),
    USER_DEFINED_Q('Q', null),
    GLONASS('R', ObservationTimeScale.GLO),
    SBAS('S', null),
    USER_DEFINED_T('T', null),
    USER_DEFINED_U('U', null),
    USER_DEFINED_V('V', null),
    USER_DEFINED_W('W', null),
    USER_DEFINED_X('X', null),
    USER_DEFINED_Y('Y', null),
    USER_DEFINED_Z('Z', null);

    private static final Map<Character, SatelliteSystem> KEYS_MAP;
    private final char key;
    private final ObservationTimeScale observationTimeScale;

    private SatelliteSystem(char key, ObservationTimeScale observationTimeScale) {
        this.key = key;
        this.observationTimeScale = observationTimeScale;
    }

    public char getKey() {
        return this.key;
    }

    public static SatelliteSystem parseSatelliteSystem(String s) throws OrekitIllegalArgumentException {
        SatelliteSystem satelliteSystem = KEYS_MAP.get(Character.valueOf(s.charAt(0)));
        if (satelliteSystem == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_SATELLITE_SYSTEM, Character.valueOf(s.charAt(0)));
        }
        return satelliteSystem;
    }

    public static SatelliteSystem parseSatelliteSystemWithGPSDefault(String s) {
        return s.isEmpty() ? GPS : SatelliteSystem.parseSatelliteSystem(s);
    }

    public ObservationTimeScale getObservationTimeScale() {
        return this.observationTimeScale;
    }

    static {
        KEYS_MAP = new HashMap<Character, SatelliteSystem>();
        for (SatelliteSystem satelliteSystem : SatelliteSystem.values()) {
            KEYS_MAP.put(Character.valueOf(satelliteSystem.getKey()), satelliteSystem);
        }
    }
}

