/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import org.orekit.gnss.SatelliteSystem;

public class SatInSystem {
    private final SatelliteSystem system;
    private final int prn;

    public SatInSystem(SatelliteSystem system, int prn) {
        this.system = system;
        this.prn = prn;
    }

    public SatelliteSystem getSystem() {
        return this.system;
    }

    public int getPRN() {
        return this.prn;
    }

    public int getTwoDigitsRinexPRN() {
        return this.system == SatelliteSystem.SBAS ? this.prn - 100 : (this.system == SatelliteSystem.QZSS ? this.prn - 192 : this.prn);
    }

    public boolean equals(Object object) {
        if (object instanceof SatInSystem) {
            SatInSystem other = (SatInSystem)object;
            return this.getSystem().equals((Object)other.getSystem()) && this.getPRN() == other.getPRN();
        }
        return false;
    }

    public int hashCode() {
        return this.getSystem().hashCode() ^ this.getPRN();
    }
}

