/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.propagation.analytical.gnss.data.GPSAlmanac;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.GNSSDate;
import org.orekit.time.TimeScales;

public class SEMParser
extends AbstractSelfFeedingLoader
implements DataLoader {
    private static final String SOURCE = "SEM";
    private static final double INC_REF = 0.3;
    private static final String DEFAULT_SUPPORTED_NAMES = ".*\\.al3$";
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private final List<GPSAlmanac> almanacs = new ArrayList<GPSAlmanac>();
    private final List<Integer> prnList = new ArrayList<Integer>();
    private final TimeScales timeScales;

    @DefaultDataContext
    public SEMParser(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales());
    }

    public SEMParser(String supportedNames, DataProvidersManager dataProvidersManager, TimeScales timeScales) {
        super(supportedNames == null ? DEFAULT_SUPPORTED_NAMES : supportedNames, dataProvidersManager);
        this.timeScales = timeScales;
    }

    public void loadData() {
        this.feed(this);
        if (this.almanacs.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SEM_ALMANAC_AVAILABLE, new Object[0]);
        }
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException, OrekitException {
        this.almanacs.clear();
        this.prnList.clear();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String[] token = this.getTokens(reader);
            int almanacNb = Integer.parseInt(token[0].trim());
            token = this.getTokens(reader);
            int week = Integer.parseInt(token[0].trim());
            double toa = Double.parseDouble(token[1].trim());
            for (int i = 0; i < almanacNb; ++i) {
                this.readAlmanac(reader, week, toa);
            }
        }
        catch (IOException | IndexOutOfBoundsException e) {
            throw new OrekitException(e, OrekitMessages.NOT_A_SUPPORTED_SEM_ALMANAC_FILE, name);
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return this.almanacs.isEmpty();
    }

    public List<GPSAlmanac> getAlmanacs() {
        return this.almanacs;
    }

    public List<Integer> getPRNNumbers() {
        return this.prnList;
    }

    @Override
    public String getSupportedNames() {
        return super.getSupportedNames();
    }

    private void readAlmanac(BufferedReader reader, int week, double toa) throws IOException {
        reader.readLine();
        GPSAlmanac almanac = new GPSAlmanac();
        almanac.setSource(SOURCE);
        try {
            String[] token = this.getTokens(reader);
            almanac.setPRN(Integer.parseInt(token[0].trim()));
            token = this.getTokens(reader);
            almanac.setSVN(Integer.parseInt(token[0].trim()));
            token = this.getTokens(reader);
            almanac.setURA(Integer.parseInt(token[0].trim()));
            token = this.getTokens(reader);
            almanac.setE(Double.parseDouble(token[0].trim()));
            almanac.setI0(this.getInclination(Double.parseDouble(token[1].trim())));
            almanac.setOmegaDot(this.toRadians(Double.parseDouble(token[2].trim())));
            token = this.getTokens(reader);
            almanac.setSqrtA(Double.parseDouble(token[0].trim()));
            almanac.setOmega0(this.toRadians(Double.parseDouble(token[1].trim())));
            almanac.setPa(this.toRadians(Double.parseDouble(token[2].trim())));
            token = this.getTokens(reader);
            almanac.setM0(this.toRadians(Double.parseDouble(token[0].trim())));
            almanac.setAf0(Double.parseDouble(token[1].trim()));
            almanac.setAf1(Double.parseDouble(token[2].trim()));
            token = this.getTokens(reader);
            almanac.setHealth(Integer.parseInt(token[0].trim()));
            token = this.getTokens(reader);
            almanac.setSatConfiguration(Integer.parseInt(token[0].trim()));
            AbsoluteDate date = new GNSSDate(week, toa, SatelliteSystem.GPS, this.timeScales).getDate();
            almanac.setDate(date);
            almanac.setTime(toa);
            almanac.setWeek(week);
            this.almanacs.add(almanac);
            this.prnList.add(almanac.getPRN());
        }
        catch (IndexOutOfBoundsException aioobe) {
            throw new IOException(aioobe);
        }
    }

    private String[] getTokens(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            return SEPARATOR.split(line.trim());
        }
        throw new IOException();
    }

    private double getInclination(double incOffset) {
        return this.toRadians(0.3 + incOffset);
    }

    private double toRadians(double semicircles) {
        return 3.1415926535898 * semicircles;
    }
}

