/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.frames.ITRFVersion;
import org.orekit.frames.Predefined;
import org.orekit.frames.VersionedITRF;
import org.orekit.utils.IERSConventions;

public class IGSUtils {
    private static final Pattern EARTH_FRAME_WITH_YEAR = Pattern.compile("(?:IER|ITR|ITRF|IGS|IGb|SLR)([0-9]{2})");
    private static final Pattern GCRF_FRAME = Pattern.compile(" *GCRF *");
    private static final Pattern EME2000_FRAME = Pattern.compile("EME(?:00|2K)");

    private IGSUtils() {
    }

    @DefaultDataContext
    public static Frame guessFrame(String name) {
        return IGSUtils.guessFrame(DataContext.getDefault().getFrames(), name);
    }

    public static Frame guessFrame(Frames frames, String name) {
        Matcher earthMatcher = EARTH_FRAME_WITH_YEAR.matcher(name);
        if (earthMatcher.matches()) {
            int yy = Integer.parseInt(earthMatcher.group(1));
            ITRFVersion itrfVersion = ITRFVersion.getITRFVersion(yy);
            IERSConventions conventions = itrfVersion.getYear() < 2003 ? IERSConventions.IERS_1996 : (itrfVersion.getYear() < 2010 ? IERSConventions.IERS_2003 : IERSConventions.IERS_2010);
            return frames.getITRF(itrfVersion, conventions, false);
        }
        Matcher gcrfMatcher = GCRF_FRAME.matcher(name);
        if (gcrfMatcher.matches()) {
            return frames.getGCRF();
        }
        Matcher eme2000Matcher = EME2000_FRAME.matcher(name);
        if (eme2000Matcher.matches()) {
            return frames.getEME2000();
        }
        return frames.getITRF(IERSConventions.IERS_2010, false);
    }

    public static String frameName(Frame frame) {
        if (frame instanceof VersionedITRF) {
            int yy = ((VersionedITRF)frame).getITRFVersion().getYear() % 100;
            return String.format(Locale.US, "IGS%02d", yy);
        }
        if (Predefined.GCRF.getName().equals(frame.getName())) {
            return "GCRF";
        }
        if (Predefined.EME2000.getName().equals(frame.getName())) {
            return "EME2K";
        }
        throw new OrekitException((Localizable)OrekitMessages.FRAME_NOT_ALLOWED, frame.getName());
    }
}

