/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss;

import org.orekit.gnss.GnssSignal;
import org.orekit.gnss.SatelliteSystem;

public enum Frequency implements GnssSignal
{
    G01(SatelliteSystem.GPS, "L1", 154.0),
    G02(SatelliteSystem.GPS, "L2", 120.0),
    G05(SatelliteSystem.GPS, "L5", 115.0),
    R01(SatelliteSystem.GLONASS, "G1", 156.5982404692082),
    R02(SatelliteSystem.GLONASS, "G2", 121.79863147605083),
    R03(SatelliteSystem.GLONASS, "G3", 117.5),
    R04(SatelliteSystem.GLONASS, "G1a", 156.5),
    R06(SatelliteSystem.GLONASS, "G2a", 122.0),
    E01(SatelliteSystem.GALILEO, "E1", 154.0),
    E05(SatelliteSystem.GALILEO, "E5a", 115.0),
    E07(SatelliteSystem.GALILEO, "E5b", 118.0),
    E08(SatelliteSystem.GALILEO, "E5 (E5a+E5b)", 116.5),
    E06(SatelliteSystem.GALILEO, "E6", 125.0),
    C01(SatelliteSystem.BEIDOU, "B1", 152.6),
    C02(SatelliteSystem.BEIDOU, "B1", 152.6),
    C05(SatelliteSystem.BEIDOU, "B2a", 115.0),
    C06(SatelliteSystem.BEIDOU, "B2", 118.0),
    C07(SatelliteSystem.BEIDOU, "B3", 124.0),
    C08(SatelliteSystem.BEIDOU, "B2 (B2a+B2b)", 116.5),
    B01(SatelliteSystem.BEIDOU, "B1", 152.6),
    B02(SatelliteSystem.BEIDOU, "B2", 118.0),
    B03(SatelliteSystem.BEIDOU, "B3", 124.0),
    B1C(SatelliteSystem.BEIDOU, "B1C", 154.0),
    B1A(SatelliteSystem.BEIDOU, "B1A", 154.0),
    B2A(SatelliteSystem.BEIDOU, "B2a", 115.0),
    B2B(SatelliteSystem.BEIDOU, "B2b", 118.0),
    B08(SatelliteSystem.BEIDOU, "B2 (B2a+B2b)", 116.5),
    B3A(SatelliteSystem.BEIDOU, "B3A", 124.0),
    J01(SatelliteSystem.QZSS, "L1", 154.0),
    J02(SatelliteSystem.QZSS, "L2", 120.0),
    J05(SatelliteSystem.QZSS, "L5", 115.0),
    J06(SatelliteSystem.QZSS, "LEX", 125.0),
    I05(SatelliteSystem.IRNSS, "L5", 115.0),
    I09(SatelliteSystem.IRNSS, "S", 243.6),
    S01(SatelliteSystem.SBAS, "L1", 154.0),
    S05(SatelliteSystem.SBAS, "L5", 115.0);

    @Deprecated
    public static final double F0 = 10.229999999999999;
    private final SatelliteSystem satelliteSystem;
    private final String name;
    private final double ratio;

    private Frequency(SatelliteSystem satelliteSystem, String name, double ratio) {
        this.satelliteSystem = satelliteSystem;
        this.name = name;
        this.ratio = ratio;
    }

    public String getName() {
        return this.name;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    @Override
    public double getRatio() {
        return this.ratio;
    }

    @Deprecated
    public double getMHzFrequency() {
        return this.getFrequency() * 1.0E-6;
    }

    @Override
    public double getFrequency() {
        return this.ratio * 1.023E7;
    }
}

